<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\NfParcela;
use Carbon\Carbon;

class GraphNfParcelaCreditoComponent extends Component
{
    public $DadosNfParcelaCreditoMes;
    public $GraficoNfParcelaCreditoMes;


    public function mount()
    {
        $dadosMeses = collect();

        // Preenche os últimos 6 meses
        for ($i = 5; $i >= 0; $i--) {
            $mes = Carbon::now()->subMonths($i);
            $dadosMeses->push([
                'mes' => $mes->month,
                'ano' => $mes->year,
                'total' => 0
            ]);
        }

        // Consulta os dados
        $dadosConsulta = NfParcela::credito()->concluido()
            ->selectRaw('MONTH(datavencimento) as mes, YEAR(datavencimento) as ano, SUM(valor) as total')
            ->where('datavencimento', '>=', Carbon::now()->subMonths(6))
            ->groupBy('mes', 'ano')
            ->get();

        // Preenche os dados nos meses
        foreach ($dadosConsulta as $dado) {
            $mesEncontrado = $dadosMeses->first(function ($mes) use ($dado) {
                return $mes['mes'] == $dado->mes && $mes['ano'] == $dado->ano;
            });

            if ($mesEncontrado) {
                $mesEncontrado['total'] = $dado->total;
            }
        }

        $this->DadosNfParcelaCreditoMes = $dadosMeses;

        $this->DadosNfParcelaCreditoMes = [
            'labels' => $dadosMeses->map(fn($mes) => "{$mes['mes']}/{$mes['ano']}")->toArray(),
            'data' => $dadosMeses->map(fn($mes) => $mes['total'])->toArray()
        ];
    }

    public function render()
    {
        return view('livewire.graph-nf-parcela-credito-component', [
            'DadosNfParcelaCreditoMes' => $this->DadosNfParcelaCreditoMes,
            'GraficoNfParcelaCreditoMes' => $this->GraficoNfParcelaCreditoMes                         

        ]);
    }
}


