<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\Nf;
use Carbon\Carbon;

class GraphPedidoCimentoComponent extends Component
{
    public $pedidosCimentoMesAtual;
    public $pedidosCimentoMesPassado;
    public $totalPedidosCimentoMesAtual;
    public $totalPedidosCimentoMesPassado;
    public $percentualPedidosCimentoMudanca;


    public function mount()
    {
        $inicioMesAtual = Carbon::now()->startOfMonth();
        $finalMesAtual = Carbon::now()->endOfMonth();
        
        $inicioMesPassado = Carbon::now()->subMonthNoOverflow()->startOfMonth();
        $finalMesPassado = Carbon::now()->subMonthNoOverflow()->endOfMonth();

        $this->pedidosCimentoMesAtual = Nf::pedido()
                                   ->join('nfitem', 'nfitem.idnf', '=', 'nf.idnf')
                                   ->wherein('idprodserv',[16,459])
                                   ->whereBetween('dataentrada', [$inicioMesAtual, $finalMesAtual])
                                   ->get();

        $this->pedidosCimentoMesPassado = Nf::pedido()
                                    ->join('nfitem', 'nfitem.idnf', '=', 'nf.idnf')
                                    ->wherein('idprodserv',[16,459])
                                    ->whereBetween('dataentrada', [$inicioMesPassado, $finalMesPassado])
                                    ->get();
        
        $this->totalPedidosCimentoMesAtual = $this->pedidosCimentoMesAtual->sum('valoritem');
        $this->totalPedidosCimentoMesPassado = $this->pedidosCimentoMesPassado->sum('valoritem');
        $this->percentualPedidosCimentoMudanca = $this->totalPedidosCimentoMesPassado > 0 
                                    ? (($this->totalPedidosCimentoMesAtual - $this->totalPedidosCimentoMesPassado) / $this->totalPedidosCimentoMesPassado) * 100 
                                    : 0;
    }

    public function render()
    {
        return view('livewire.graph-pedido-cimento-component', [
            'pedidosCimentoMesAtual' => $this->pedidosCimentoMesAtual,
            'pedidosMesPassado' => $this->pedidosCimentoMesPassado,
            'percentualPedidosCimentoMudanca' => $this->percentualPedidosCimentoMudanca,
            'totalPedidosCimentoMesAtual' => $this->totalPedidosCimentoMesAtual,
            'totalPedidosCimentoMesPassado' => $this->totalPedidosCimentoMesPassado           

        ]);
    }
}


