<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\Nf;
use Carbon\Carbon;

class GraphPedidoDieselComponent extends Component
{
    public $pedidosDieselMesAtual;
    public $pedidosDieselMesPassado;
    public $totalPedidosDieselMesAtual;
    public $totalPedidosDieselMesPassado;
    public $percentualPedidosDieselMudanca;


    public function mount()
    {
        $inicioMesAtual = Carbon::now()->startOfMonth();
        $finalMesAtual = Carbon::now()->endOfMonth();
        
        $inicioMesPassado = Carbon::now()->subMonthNoOverflow()->startOfMonth();
        $finalMesPassado = Carbon::now()->subMonthNoOverflow()->endOfMonth();

        $this->pedidosDieselMesAtual = Nf::pedido()
                                   ->join('nfitem', 'nfitem.idnf', '=', 'nf.idnf')
                                   ->wherein('idprodserv',[20,31])
                                   ->whereBetween('dataentrada', [$inicioMesAtual, $finalMesAtual])
                                   ->get();

        $this->pedidosDieselMesPassado = Nf::pedido()
                                    ->join('nfitem', 'nfitem.idnf', '=', 'nf.idnf')
                                    ->wherein('idprodserv',[20,31])
                                    ->whereBetween('dataentrada', [$inicioMesPassado, $finalMesPassado])
                                    ->get();

        $this->totalPedidosDieselMesAtual = $this->pedidosDieselMesAtual->sum('valoritem');
        $this->totalPedidosDieselMesPassado = $this->pedidosDieselMesPassado->sum('valoritem');
        $this->percentualPedidosDieselMudanca = $this->totalPedidosDieselMesPassado > 0 
                                    ? (($this->totalPedidosDieselMesAtual - $this->totalPedidosDieselMesPassado) / $this->totalPedidosDieselMesPassado) * 100 
                                    : 0;
    }

    public function render()
    {
        return view('livewire.graph-pedido-diesel-component', [
            'pedidosDieselMesAtual' => $this->pedidosDieselMesAtual,
            'pedidosMesPassado' => $this->pedidosDieselMesPassado,
            'percentualPedidosDieselMudanca' => $this->percentualPedidosDieselMudanca,
            'totalPedidosDieselMesAtual' => $this->totalPedidosDieselMesAtual,
            'totalPedidosDieselMesPassado' => $this->totalPedidosDieselMesPassado           

        ]);
    }
}


