<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\NfParcela;
use Carbon\Carbon;

class NfParcelaDebitoComponent extends Component
{
    public $debitoAtivoMesAtual;
    public $debitoAtivoMesPassado;
    public $totalAtivoDebitoMesAtual;
    public $totalAtivoDebitoMesPassado;
    public $percentualAtivoDebitoMudanca;

    public $debitoConcluidoMesAtual;
    public $debitoConcluidoMesPassado;
    public $totalConcluidoDebitoMesAtual;
    public $totalConcluidoDebitoMesPassado;
    public $percentualConcluidoDebitoMudanca;


    public function mount()
    {
        // Utilizando a biblioteca Carbon para definir a data de início do mês atual
        $inicioMesAtual = Carbon::now()->startOfMonth();

        // Utilizando a biblioteca Carbon para definir a data de final do mês atual
        $finalMesAtual = Carbon::now()->endOfMonth();

        // Utilizando Carbon para definir a data de início do mês passado
        // 'subMonthNoOverflow' evita que a data mude para o mês anterior se o mês atual tem menos dias
        $inicioMesPassado = Carbon::now()->subMonthNoOverflow()->startOfMonth();

        // Utilizando Carbon para definir a data de final do mês passado
        $finalMesPassado = Carbon::now()->subMonthNoOverflow()->endOfMonth();

        // Consultando registros de débitos ativos para o mês atual.
        $this->debitoAtivoMesAtual = NfParcela::debito()->Ativo()
        ->whereBetween('datavencimento', [$inicioMesAtual, $finalMesAtual])
        ->get();

        // Consultando registros de débitos ativos para o mês passado.
        $this->debitoAtivoMesPassado = NfParcela::debito()->Ativo()
                                        ->whereBetween('datavencimento', [$inicioMesPassado, $finalMesPassado])
                                        ->get();

        // Calculando o total de valores dos débitos ativos para o mês atual.
        $this->totalAtivoDebitoMesAtual = $this->debitoAtivoMesAtual->sum('valor');

        // Calculando o total de valores dos débitos ativos para o mês passado.
        $this->totalAtivoDebitoMesPassado = $this->debitoAtivoMesPassado->sum('valor');

        // Calculando a mudança percentual do total de débitos ativos do mês passado para o mês atual.
        $this->percentualAtivoDebitoMudanca = $this->totalAtivoDebitoMesPassado > 0 
                    ? (($this->totalAtivoDebitoMesAtual - $this->totalAtivoDebitoMesPassado) / $this->totalAtivoDebitoMesPassado) * 100 
                    : 0;

        // Consultando débitos concluídos para o mês atual.
        $this->debitoConcluidoMesAtual = NfParcela::debito()->Concluido()
                                            ->whereBetween('datavencimento', [$inicioMesAtual, $finalMesAtual])
                                            ->get();

        // Consultando débitos concluídos para o mês passado.
        $this->debitoConcluidoMesPassado = NfParcela::debito()->Concluido()
                                            ->whereBetween('datavencimento', [$inicioMesPassado, $finalMesPassado])
                                            ->get();

        // Calculando o total de valores dos débitos concluídos para o mês atual.
        $this->totalConcluidoDebitoMesAtual = $this->debitoConcluidoMesAtual->sum('valor');

        // Calculando o total de valores dos débitos concluídos para o mês passado.
        $this->totalConcluidoDebitoMesPassado = $this->debitoConcluidoMesPassado->sum('valor');

        // Calculando a mudança percentual do total de débitos concluídos do mês passado para o mês atual.
        $this->percentualConcluidoDebitoMudanca = $this->totalConcluidoDebitoMesPassado > 0 
            ? (($this->totalConcluidoDebitoMesAtual - $this->totalConcluidoDebitoMesPassado) / $this->totalConcluidoDebitoMesPassado) * 100 
            : 0;

    }

    public function render()
    {
        return view('livewire.nf-parcela-debito-component', [
            'debitoAtivoMesAtual' => $this->debitoAtivoMesAtual,
            'debitoAtivoMesPassado' => $this->debitoAtivoMesPassado,
            'totalAtivoDebitoMesAtual' => $this->totalAtivoDebitoMesAtual,
            'totalAtivoDebitoMesPassado' => $this->totalAtivoDebitoMesPassado,
            'percentualAtivoDebitoMudanca' => $this->percentualAtivoDebitoMudanca,
            'debitoConcluidoMesAtual' => $this->debitoConcluidoMesAtual,
            'debitoConcluidoMesPassado' => $this->debitoConcluidoMesPassado,
            'totalConcluidoDebitoMesAtual' => $this->totalConcluidoDebitoMesAtual,
            'totalConcluidoDebitoMesPassado' => $this->totalConcluidoDebitoMesPassado,
            'percentualConcluidoDebitoMudanca' => $this->percentualConcluidoDebitoMudanca
        ]);
    }

}


