<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HandlesFileUploads;

class Agencia extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'agencia';
    protected $primaryKey = 'idagencia';

    protected $fillable = [
        'idempresa',
        'agencia',
        'nagencia',
        'noperacao',
        'nconta',
        'gerente',
        'telefone',
        'status',
        'ord',
        'remessa',
        'boleto',
        'retornorm',
    ];

    public function empresa()
    {
        return $this->hasOne(Empresa::class, 'idempresa', 'idempresa');
    }
}
