<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class Contrato extends Model
{
    use HasFactory, HandlesFileUploads;
    
    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'contrato';
    protected $primaryKey = 'idcontrato';
    protected $fillable = [
        'idempresa',
        'idpessoa',
        'idprodservtipo',
        'datainicio',
        'datafim',
        'dataconclusao',
        'nome',
        'cep',
        'endereco',
        'numero',
        'complemento',
        'bairro',
        'cidade',
        'estado',
        'status',
        'criadopor',
        'alteradopor',
    ];
    
    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    public function empresa()
    {
        return $this->hasOne(Empresa::class, 'idempresa', 'idempresa');
    }

    public function pessoa()
    {
        return $this->belongsTo(Pessoa::class, 'idpessoa', 'idpessoa');
    }
    public function prodservtipo()
    {
        return $this->hasOne(TipoProdutoServico::class, 'idprodservtipo', 'idprodservtipo'); 
    }
    
}
