<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class ContratoVeiculo extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'contratoveiculo';
    protected $primaryKey = 'idcontratoveiculo';
    protected $fillable = [
        'idcontrato',
        'idveiculo',
        'idempresa',
        'criadopor',
        'alteradopor',
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    public function contrato()
    {
        return $this->belongsTo(Contrato::class, 'idcontrato');
    }

    public function veiculo()
    {
        return $this->belongsTo(Veiculo::class, 'idveiculo');
    }

    public function empresa()
    {
        return $this->hasOne(Empresa::class, 'idempresa', 'idempresa');
    }

}
