<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class Evento extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'evento';
    protected $primaryKey = 'idevento';
    protected $fillable = [
        'ideventotipo',
        'idempresa', 
        'idpessoa',
        'idcliente',
        'idveiculo',
        'idobjeto',
        'objeto',
        'evento',
        'descricao',
        'status',
        'data',
        'hora',
        'datafim',
        'horafim',
        'qtd',
        'hora',
        'item',
        'idprodserv',
        'valoritem',
        'valorun',

        'idnfitem'
    ];

    public function eventotipo()
    {
        return $this->belongsTo(EventoTipo::class, 'ideventotipo');
    }

    public function nfitem()
    {
        return $this->hasOne(NfItem::class, 'idnfitem');
    }

    public function pessoas()
    {
        return $this->belongsToMany(Pessoa::class, 'eventopessoas', 'idevento', 'idpessoa');
    }

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function empresa() : HasOne
    {
        return $this->hasOne(Empresa::class, 'idempresa', 'idempresa');
    }

    public function cliente() : HasOne
    {
        return $this->hasOne(Pessoa::class, 'idpessoa', 'idcliente');
    }
}
