<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class EventoTipo extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'eventotipo';
    protected $primaryKey = 'ideventotipo';
    protected $fillable = [
        'eventotipo',
        'descricao',
        'idprodserv',
        'status',
        'veiculo',
        'pessoa',
        'qtd',
        'hora',
        'venda',
        'datapadrao',
        'horapadrao',
        'idempresa'
    ];

    public function evento()
    {
        return $this->belongsTo(Evento::class, 'ideventotipo');
    }

    public function prodserv()
    {
        return $this->belongsTo(ProdutoServico::class, 'idprodserv');
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class, 'idempresa', 'idempresa');
    }

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }
    

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
}
