<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class GrupoItem extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'grupoitem';
    protected $primaryKey = 'idgrupoitem';
    protected $fillable = [
        'grupoitem',
        'status',
        'idempresa'
    ];

    public function nfitem()
    {
        return $this->hasOne(NfITem::class, 'idgrupoitem');
    }

    public function empresa()
    {
        return $this->hasOne(Empresa::class, 'idempresa', 'idempresa');
    }

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function scopeActive(Builder $query)
    {
        $query->where('status', 'ATIVO');
    }
}
