<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class NfItem extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'nfitem';
    protected $primaryKey = 'idnfitem';
    protected $fillable = [
        'idnf',
        'idempresa',
        'idprodserv',
        'iditem',
        'item',
        'idgrupoitem',
        'idtipoitem',
        'qtd',
        'un',
        'valorun',
        'valoritem' 
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    function prodserv()
    {
        return $this->hasOne(ProdutoServico::class, 'idprodserv', 'idprodserv');
    }

    function grupoitem()
    {
        return $this->hasOne(GrupoItem::class, 'idgrupoitem', 'idgrupoitem');
    }

    function evento()
    {
        return $this->hasOne(Evento::class, 'idnfitem');
    }

}
