<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class Pessoa extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'pessoa';
    protected $primaryKey = 'idpessoa';
    protected $fillable = [
        'idempresa',
        'nome',
        'razaosocial',
        'cpfcnpj',
        'inscestadual',
        'cep',
        'endereco',
        'numero',
        'complemento',
        'bairro',
        'cidade',
        'estado',
        'responsavel',
        'telefone',
        'celular',
        'celular2',
        'datanascimento',
        'rg',
        'nomepai',
        'nomemae',
        'estadocivil',
        'cargo',
        'admissao',
        'admissaomotivo',
        'demissao',
        'demissaomotivo',
        'email',
        'website',
        'descricao',
        'observacao',
        'status',
        'tipo',
        'criadopor',
        'alteradopor'
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    public function scopeActive(Builder $query): void
    {
        $query->where('status', 'ATIVO');
    }

    public function scopeFornecedor(Builder $query): void
    {
        // F: fornecedor
        $query->where('tipo', 'fornecedor');
    }

    public function scopeCliente(Builder $query): void
    {
        $query->where('tipo', 'cliente');
    }

    public function scopeFuncionario(Builder $query): void
    {
        $query->where('tipo', 'F');
    }

    public function scopeFuncionarioOuCliente(Builder $query): void
{
    $query->where(function ($query) {
        $query->where('tipo', 'F')
            ->orWhere('tipo', 'cliente');
    });
}

    // public function tipo()
    // {
    //     return $this->hasOne(TipoPessoa::class, 'idtipopessoa', 'idtipopessoa');
    // }

    public function empresa()
    {
        return $this->hasOne(Empresa::class, 'idempresa', 'idempresa');
    }
}
