<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class Produto extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'prodserv';
    protected $primaryKey = 'idprodserv';
    protected $fillable = [
        'idprodservtipo',
        'idempresa',
        'tipo',
        'prodserv',
        'status',
        'valorcompra',
        'valorvenda',
        'estoque',
        'unidade',
        'estoqueminimo',
        'email',
        'telefone',
        'celular',
        'criadopor',
        'alteradopor'
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }
}
