<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class TipoPessoa extends Model
{
    use HasFactory, HandlesFileUploads;

    protected $table = 'tipopessoa';
    protected $primaryKey = 'idtipopessoa';

    protected $fillable = [
        ''
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    public function scopeActive(Builder $query) : void
    {
        $query->where('status', 'ATIVO');
    }
}
