<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class TipoProdutoServico extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $table = 'prodservtipo';
    protected $primaryKey = 'idprodservtipo';

    protected $fillable = [
        'idempresa',
        'prodservtipo',
        'status',
        'criadopor',
        'criadoem',
        'alteradopor',
        'alteradoem'
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    public function empresa() : HasOne
    {
        return $this->hasOne(Empresa::class, 'idempresa', 'idempresa');
    }

    public function scopeActive(Builder $query)
    {
        $query->where('status', 'ATIVO');
    }
}
