<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Scopes\TenantScope;

class Upload extends Model
{
    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';
    
    protected $table = 'upload';
    protected $primaryKey = 'idupload';
    protected $fillable = ['idtenant','idempresa','objeto', 'idobjeto', 'caminho', 'criadopor', 'criadoem', 'alteradopor', 'alteradoem'];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }
    
    public function uploadable()
    {
        return $this->morphTo('objeto', 'idobjeto');
    }
}