<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use App\Traits\HandlesFileUploads;
use App\Scopes\TenantScope;

class Veiculo extends Model
{
    use HasFactory, HandlesFileUploads;

    const CREATED_AT = 'criadoem';
    const UPDATED_AT = 'alteradoem';

    protected $primaryKey = 'idveiculo';
    protected $table = 'veiculo';
    protected $fillable = [
        'idempresa',
        'idpessoa',
        'idcontrato',
        'tipoveiculo',
        'ano',
        'marca',
        'modelo',
        'placa',
        'renavan',
        'chassi',
        'km',
        'cor',
        'rastreador',
        'crv',
        'status',
        'idseguradora',
        'apolice',
        'datavencimento'
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);
    }

    public function pessoa() : HasOne
    {
        return $this->hasOne(Pessoa::class, 'idpessoa', 'idpessoa');
    }

    public function seguradora() : HasOne
    {
        return $this->hasOne(Pessoa::class, 'idpessoa', 'idseguradora');
    }

    public function empresa() : HasOne
    {
        return $this->hasOne(Empresa::class, 'idempresa', 'idempresa');
    }
}
