<?php

namespace App\Scopes;

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Eloquent\Scope;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class TenantScope implements Scope
{
    private static $applyingScope = false;

    public function apply(Builder $builder, Model $model)
    {

        if (self::$applyingScope) {
            return;
        }

        self::$applyingScope = true;



        Log::info('Entrando no Scopo: '.$model->getTable());
        
        
        if (auth()->user() and $model->getTable() === 'users') {
            $userId = auth()->user()->id;
            $userTenantId = auth()->user()->idtenant;
            if (session('selectedTenant')){
                Log::info("Sql:".$model->getTable().".idtenant = ".session('selectedTenant')->idtenant);
                $builder->where('id', $userId)->orwhere($model->getTable() . '.idtenant', session('selectedTenant')->idtenant);
            }else{
                Log::info("Sql:".$model->getTable().".idtenant = ".auth()->user()->idtenant);
                $builder->where($model->getTable() . '.idtenant', auth()->user()->idtenant);
            }
        } elseif (Schema::hasColumn($model->getTable(), 'idempresa') and $model->getTable() != 'upload' and $model->getTable() != 'empresa' and $model->getTable() != 'tenant' and $model->getTable() != 'users') {
                // Se a tabela tem a coluna idempresa
            Log::info('A tabela:'.$model->getTable()." possui a coluna idempresa.");
            Log::info('Checando autenticação no TenantScope:'.$model->getTable());
            try {
                if (auth()->check()) {
                    Log::info('Usuário está autenticado no TenantScope.');

                    if (session('selectedTenant')){
                        $builder->whereExists(function ($query) use ($model) {
                            $query->select(DB::raw(1))
                                ->from('empresa')
                                ->whereColumn('empresa.idempresa', $model->getTable() . '.idempresa')
                                ->where('empresa.idtenant', session('selectedTenant')->idtenant);
                        });
                    }else{
                        $builder->whereExists(function ($query) use ($model) {
                            $query->select(DB::raw(1))
                                ->from('empresa')
                                ->whereColumn('empresa.idempresa', $model->getTable() . '.idempresa')
                                ->where('empresa.idtenant', auth()->user()->idtenant);
                        });
                    }
                    
                }
            } catch (\Throwable $e) {
                Log::error("Erro ao aplicar TenantScope: " . $e->getMessage() . ' in file ' . $e->getFile() . ' on line ' . $e->getLine());
            }
        }else{
            Log::info('A tabela:'.$model->getTable()." não possui a coluna idempresa.");
            if (auth()->check() && auth()->user()->idtenant and $model->getTable() != 'tenant') {
                if (session('selectedTenant')){
                    Log::info("Sql:".$model->getTable().".idtenant = ".session('selectedTenant')->idtenant);
                    $builder->where($model->getTable() . '.idtenant', session('selectedTenant')->idtenant);
                }else{
                    Log::info("Sql:".$model->getTable().".idtenant = ".auth()->user()->idtenant);
                    $builder->where($model->getTable() . '.idtenant', auth()->user()->idtenant);
                }
                $querySql = $builder->toSql();
                $bindings = $builder->getBindings();

                // Log da query
                Log::info('SQL Query: ' . $querySql);
                Log::info('Bindings: ' . implode(', ', $bindings));
            }            
        }

        self::$applyingScope = false;
      
    }
}
