<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('veiculos', function (Blueprint $table) {
            $table->id();
            $table->int('idempresa');
            $table->int('idpessoa');
            $table->foreign('idpessoa')->references('idpessoa')->on('pessoa');
            $table->string('tipoveiculo', 45);
            $table->int('ano');
            $table->string('marca', 45);
            $table->string('modelo', 45);
            $table->string('renavan', 45);
            $table->string('chassi', 45);
            $table->string('km', 45);
            $table->string('cor', 45);
            $table->string('status', 45);
            $table->string('criadopor', 45);
            $table->string('alteradopor', 45);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('veiculos');
    }
};
