<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pessoas', function (Blueprint $table) {
            $table->id();
            $table->int('idempresa');
            $table->foreign('idempresa')->references('idempresa')->on('empresa');
            $table->string('nome', 120);
            $table->string('razaosocial', 120);
            $table->string('cpfcnpj', 45);
            $table->string('inscestadual', 45);
            $table->string('cep', 45);
            $table->string('endereco', 45);
            $table->string('numero', 45);
            $table->string('complemento', 45);
            $table->string('bairro', 45);
            $table->string('cidade', 45);
            $table->string('estado', 45);
            $table->string('datanascimento', 45);
            $table->string('rg', 45);
            $table->string('nomepai', 45);
            $table->string('nomemae', 45);
            $table->string('estadocivil', 45);
            $table->string('cargo', 45);
            $table->date('admissao');
            $table->string('admissaomotivo', 45);
            $table->date('demissao');
            $table->string('demissaomotivo', 45);
            $table->string('status', 45);
            $table->string('criadopor', 45);
            $table->string('alteradopor', 45);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pessoas');
    }
};
