<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('nf', function (Blueprint $table) {
            $table->id('idnf');
            $table->integer('idobjeto');
            $table->string('tipoobjeto', 45);
            $table->unsignedBigInteger('idempresa');
            $table->foreign('idempresa')->references('idempresa')->on('empresa');
            $table->unsignedBigInteger('idpessoa');
            $table->foreign('idpessoa')->references('idpessoa')->on('pessoa');
            $table->string('tipo', 1)->nulalble();
            $table->date('dataemissao');
            $table->date('dataentrada');
            $table->unsignedBigInteger('idformapagamento');
            $table->foreign('idformapagamento')->references('idformapagamento')->on('formapagamento');
            $table->integer('qtdparcela');
            $table->string('status', 45);
            $table->date('datainicio');
            $table->date('datafim');
            $table->decimal('valornf', 10, 0);
            $table->decimal('descontonf', 10, 0);
            $table->decimal('totalnf', 10, 0);
            $table->timestamp('criadoem')->useCurrent();
            $table->string('criadopor', 45)->nullable();
            $table->timestamp('alteradoem')->useCurrent();
            $table->string('alteradopor', 45)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('nf');
    }
};
