<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('nfitem', function (Blueprint $table) {
            $table->id('idnfitem');
            $table->unsignedBigInteger('idnf');
            $table->foreign('idnf')->references('idnf')->on('nf');
            $table->unsignedBigInteger('idprodserv');
            $table->foreign('idprodserv')->references('idprodserv')->on('prodserv');
            $table->decimal('qtd',12,4);
            $table->string('un',45);
            $table->string('moeda',3);
            $table->decimal('vlritemext',15,4);
            $table->timestamp('criadoem')->useCurrent();
            $table->string('criadopor', 45)->nullable();
            $table->timestamp('alteradoem')->useCurrent();
            $table->string('alteradopor', 45)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('nf_items');
    }
};
