<div class="card ">
    <div class="card-header card-header-primary">
        <h4 class="card-title">{{ __('Adicionar nova Agência') }}</h4>
        <p class="card-category"></p>
    </div>
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 text-right">
                <a href="{{ route('admin.agencias.index') }}"
                   class="btn btn-sm btn-primary">{{ __('Voltar para a lista') }}</a>
            </div>
        </div>

        @if ($errors->any() || session('error'))
            <div class="row">
                <div class="col-sm-12">
                    <div class="alert alert-danger">
                        <button type="button" class="close" data-dismiss="alert"
                                aria-label="Close">
                            <i class="tim-icons icon-simple-remove"></i>
                        </button>
                        <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                    </div>
                </div>
            </div>
        @endif

        <div class="row">
            <div class="col-8">
                <div class="row">
                    {{-- Empresa --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Empresa</label>
                            <select class="form-control" name="idempresa">
                                <option value="" disabled="disabled">- Selecionar -</option>
                            @foreach($empresas as $empresa)
                                <option value="{{ $empresa->idempresa }}" {{ ((isset($agencia) && $empresa->idempresa == $agencia->empresa->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>
                    {{-- Agência --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 {{ $errors->has('agencia') ? ' is-invalid' : '' }}">
                            <label>{{ __('Agência') }}</label>
                            <input class="form-control{{ $errors->has('agencia') ? ' is-invalid' : '' }}"
                            name="agencia" id="input-agencia" type="text"
                            value="{{ isset($agencia) ? $agencia->agencia : old('agencia') }}" placeholder="{{ __('Agência') }}"/>
                            @if ($errors->has('agencia'))
                                <span id="agencia-error" class="error text-danger"
                                    for="input-agencia">{{ $errors->first('agencia') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- N° da Agência --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 {{ $errors->has('nagencia') ? ' is-invalid' : '' }}">
                            <label>{{ __('N° da Agência') }}</label>
                            <input class="form-control {{ $errors->has('nagencia') ? ' is-invalid' : '' }}"
                            name="nagencia" id="input-nagencia" type="text"
                            value="{{ isset($agencia) ? $agencia->nagencia : old('nagencia') }}" placeholder="{{ __('N° da Agência') }}"/>
                            @if ($errors->has('nagencia'))
                                <span id="nagencia-error" class="error text-danger"
                                    for="input-nagencia">{{ $errors->first('nagencia') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- N° da operação --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 {{ $errors->has('noperacao') ? ' is-invalid' : '' }}">
                            <label>{{ __('N° da operação') }}</label>
                            <input class="form-control{{ $errors->has('noperacao') ? ' is-invalid' : '' }}"
                            name="noperacao" id="input-noperacao" type="text"
                            value="{{ isset($agencia) ? $agencia->noperacao : old('noperacao') }}" placeholder="{{ __('N° da operação') }}"/>
                            @if ($errors->has('noperacao'))
                                <span id="noperacao-error" class="error text-danger"
                                    for="input-noperacao">{{ $errors->first('noperacao') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- N° da conta --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 {{ $errors->has('nconta') ? ' is-invalid' : '' }}">
                            <label>{{ __('N° da conta') }}</label>
                            <input class="form-control {{ $errors->has('nconta') ? ' is-invalid' : '' }}"
                            name="nconta" id="input-nconta" type="text"
                            value="{{ isset($agencia) ? $agencia->nconta : old('nconta') }}" placeholder="{{ __('N° da conta') }}"/>
                            @if ($errors->has('nconta'))
                                <span id="nconta-error" class="error text-danger"
                                    for="input-nconta">{{ $errors->first('nconta') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Gerente --}}
                    <div class="col-8">
                        <div class="input-group input-group-static my-3 {{ $errors->has('gerente') ? ' is-invalid' : '' }}">
                            <label>{{ __('Gerente') }}</label>
                            <input class="form-control{{ $errors->has('gerente') ? ' is-invalid' : '' }}"
                            name="gerente" id="input-gerente" type="text"
                            value="{{ isset($agencia) ? $agencia->gerente : old('gerente') }}" placeholder="{{ __('Gerente') }}"/>
                            @if ($errors->has('gerente'))
                                <span id="gerente-error" class="error text-danger"
                                    for="input-gerente">{{ $errors->first('gerente') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Telefone --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 {{ $errors->has('telefone') ? ' is-invalid' : '' }}">
                            <label>{{ __('Telefone') }}</label>
                            <input class="form-control telefone {{ $errors->has('telefone') ? ' is-invalid' : '' }}"
                            name="telefone" id="input-telefone" type="text"
                            value="{{ isset($agencia) ? $agencia->telefone : old('telefone') }}" placeholder="{{ __('Telefone') }}"/>
                            @if ($errors->has('telefone'))
                                <span id="telefone-error" class="error text-danger"
                                    for="input-telefone">{{ $errors->first('telefone') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Ordem --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 {{ $errors->has('ord') ? ' is-invalid' : '' }}">
                            <label>{{ __('Ordem') }}</label>
                            <input class="form-control{{ $errors->has('ord') ? ' is-invalid' : '' }}"
                            name="ord" id="input-ord" type="text"
                            value="{{ isset($agencia) ? $agencia->ord : old('ord') }}" placeholder="{{ __('Ordem') }}"/>
                            @if ($errors->has('ord'))
                                <span id="ord-error" class="error text-danger"
                                    for="input-ord">{{ $errors->first('ord') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Remessa --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 {{ $errors->has('remessa') ? ' is-invalid' : '' }}">
                            <label>{{ __('Remessa') }}</label>
                            <input class="form-control{{ $errors->has('remessa') ? ' is-invalid' : '' }}"
                            name="remessa" id="input-remessa" type="text"
                            value="{{ isset($agencia) ? $agencia->remessa : old('remessa') }}" placeholder="{{ __('Remessa') }}"/>
                            @if ($errors->has('remessa'))
                                <span id="remessa-error" class="error text-danger"
                                    for="input-remessa">{{ $errors->first('remessa') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Boleto --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 {{ $errors->has('boleto') ? ' is-invalid' : '' }}">
                            <label>{{ __('Boleto') }}</label>
                            <input class="form-control{{ $errors->has('boleto') ? ' is-invalid' : '' }}"
                            name="boleto" id="input-boleto" type="text"
                            value="{{ isset($agencia) ? $agencia->boleto : old('boleto') }}" placeholder="{{ __('Boleto') }}"/>
                            @if ($errors->has('boleto'))
                                <span id="boleto-error" class="error text-danger"
                                    for="input-boleto">{{ $errors->first('boleto') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- TODO: Corrigir label --}}
                    {{-- Retorno --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 {{ $errors->has('retornorm') ? ' is-invalid' : '' }}">
                            <label>{{ __('Retorno') }}</label>
                            <input class="form-control{{ $errors->has('retornorm') ? ' is-invalid' : '' }}"
                            name="retornorm" id="input-retornorm" type="text"
                            value="{{ isset($agencia) ? $agencia->retornorm : old('retornorm') }}" placeholder="{{ __('Retorno') }}"/>
                            @if ($errors->has('retornorm'))
                                <span id="retornorm-error" class="error text-danger"
                                    for="input-retornorm">{{ $errors->first('retornorm') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Status --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 {{ $errors->has('status') ? ' is-invalid' : '' }}">
                            <label>{{ __('Status') }}</label>
                            <select class="form-control" name="status">
                                <option value='ATIVO' {{ ((isset($agencia) && $agencia->status == 'ATIVO') || (old('status') == 'ATIVO')) ? 'selected' : '' }}>Ativo</option>
                                <option value='INATIVO' {{ ((isset($agencia) && $agencia->status == 'INATIVO') || (old('status') == 'INATIVO')) ? 'selected' : '' }}>Inativo</option>
                            </select>
                            @if ($errors->has('status'))
                                <span id="status-error" class="error text-danger"
                                    for="input-status">{{ $errors->first('status') }}</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="card-footer ml-auto mr-auto">
        <button type="submit" class="btn btn-primary">{{ __((isset($agencia) ? 'Atualizar' : 'Adicionar').' Agência') }}</button>
    </div>
</div>
