@push('css')
    {{-- Select2 --}}
    <link rel="stylesheet" href="{{ asset('assets/css/select2.min.css') }}">
@endpush
<meta name="csrf-token" content="{{ csrf_token() }}">
<?php
 $opt = '';
if(isset($veiculos)){
    foreach($veiculos as $veiculo)
    {   
            $opt .='<option value="'.$veiculo->idveiculo.'">'.$veiculo->marca.'/'.$veiculo->modelo.' | '.$veiculo->placa.'</option>';
    }
} 

?>
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Gerenciamento de Contrato</h5>
        </div>
    </div>
    <div class="card-body ">
    {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
            @endif

        <div class="row">
            @if (isset($contrato))
            <div class="col-md-9 col-lg-9"> 
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$contrato->idcontrato;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{$bg_status}}"><?=$contrato->status;?></span>
            </div>
        @endif
        </div>
    </div>
</div>
<div class="card mb-4">
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <div class="row">
                    {{-- Nome --}}
                    <div class="col-8">
                        <div class="input-group input-group-static my-3 {{ $errors->has('nome') ? ' is-invalid' : '' }}">
                            <label>{{ __('Nome do Contrato') }}</label>
                            <input class="form-control nome {{ $errors->has('nome') ? ' is-invalid' : '' }}"
                            name="nome" id="input-nome" type="text"
                            value="{{ isset($contrato) ? $contrato->nome : old('nome') }}" placeholder="{{ __('Nome') }}"
                            required="true" aria-required="true"/>
                            @if ($errors->has('nome'))
                                <span id="nome-error" class="error text-danger"
                                    for="input-nome">{{ $errors->first('nome') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Empresa --}}
                    <div class="col-8">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Empresa</label>
                            <select class="form-control" name="idempresa">
                                <option value="">- Selecionar -</option>
                            @foreach($empresas as $empresa)
                                <option value="{{ $empresa->idempresa }}" {{ ((isset($contrato) && $empresa->idempresa == $contrato->empresa->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>
                    {{-- Pessoa --}}
                    <div class="col-8">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Cliente</label>
                            <select class="form-control" name="idpessoa" required="true" aria-required="true" >
                                <option value=''>Selecionar</option>
                                @foreach($pessoas as $pessoa)
                                    <option value="{{ $pessoa->idpessoa }}" {{ ((isset($contrato) && ($pessoa->idpessoa && $pessoa->idpessoa == $contrato->pessoa->idpessoa)) || (old('idpessoa') == $pessoa->idpessoa)) ? 'selected' : '' }}>{{$pessoa->nome}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>  
                    {{-- Tipo de Produto e Serviço --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Tipo</label>
                            <select class="form-control" name="idprodservtipo" required="true" aria-required="true" 
                            @if (isset($pedido))
                                disabled="disabled" readonly
                            @endif>
                                <option value="" disabled="disabled">- Selecionar -</option>
                                @foreach($tiposProdutoServico as $tipoProdutoServico)
                                    <option value="{{ $tipoProdutoServico->idprodservtipo }}" {{ ((isset($contrato) && $tipoProdutoServico->idprodservtipo == $contrato->idprodservtipo) || (old('idprodservtipo') == $tipoProdutoServico->idprodservtipo)) ? 'selected' : '' }}>{{$tipoProdutoServico->prodservtipo}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        {{-- Data Início --}}
                        <div class="col-4">
                            <div
                                class="input-group input-group-static my-3 {{ $errors->has('datainicio') ? ' is-invalid' : '' }}">
                                <label>{{ __('Data de Início') }}</label>
                                <input class="form-control {{ $errors->has('datainicio') ? ' is-invalid' : '' }}"
                                    name="datainicio" id="input-datainicio" type="date"
                                    value="{{ isset($contrato) ? $contrato->datainicio : old('datainicio') }}"
                                    placeholder="{{ __('Data de Início') }}"/>
                                @if ($errors->has('datainicio'))
                                    <span id="datainicio-error" class="error text-danger"
                                        for="input-datainicio">{{ $errors->first('datainicio') }}</span>
                                @endif
                            </div>  
                        </div>
                        {{-- Data Fim --}}
                        <div class="col-4">
                            <div
                                class="input-group input-group-static my-3 {{ $errors->has('datafim') ? ' is-invalid' : '' }}">
                                <label>{{ __('Prazo de Entrega') }}</label>
                                <input class="form-control {{ $errors->has('datafim') ? ' is-invalid' : '' }}"
                                    name="datafim" id="input-datafim" type="date"
                                    value="{{ isset($contrato) ? $contrato->datafim : old('datafim') }}"
                                    placeholder="{{ __('Prazo de Entrega') }}"  />
                                @if ($errors->has('datafim'))
                                    <span id="datafim-error" class="error text-danger"
                                        for="input-datafim">{{ $errors->first('datafim') }}</span>
                                @endif
                            </div>  
                        </div>
                        {{-- Data Conclusão --}}
                        <div class="col-4">
                            <div
                                class="input-group input-group-static my-3 {{ $errors->has('dataconclusao') ? ' is-invalid' : '' }}">
                                <label>{{ __('Data de Entrega') }}</label>
                                <input class="form-control {{ $errors->has('dataconclusao') ? ' is-invalid' : '' }}"
                                    name="dataconclusao" id="input-dataconclusao" type="date"
                                    value="{{ isset($contrato) ? $contrato->dataconclusao : old('dataconclusao') }}"
                                    placeholder="{{ __('Data de Entrega') }}"  />
                                @if ($errors->has('dataconclusao'))
                                    <span id="dataconclusao-error" class="error text-danger"
                                        for="input-dataconclusao">{{ $errors->first('dataconclusao') }}</span>
                                @endif
                            </div>  
                        </div>
                    </div> 
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card mb-4">
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <h4 class="mb-3 bg-light">Endereço</h4>
            </div>
            <div class="col-md-12 col-lg-12">
                <div class="row">
                    {{-- Cep --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 {{ $errors->has('cep') ? ' is-invalid' : '' }}">
                            <label>{{ __('Cep') }}</label>
                            <input class="form-control cep {{ $errors->has('cep') ? ' is-invalid' : '' }}"
                            name="cep" id="input-cep" type="text"
                            value="{{ isset($contrato) ? $contrato->cep : old('cep') }}" placeholder="{{ __('Cep') }}"
                            required="true" aria-required="true"/>
                            @if ($errors->has('cep'))
                                <span id="cep-error" class="error text-danger"
                                    for="input-cep">{{ $errors->first('cep') }}</span>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="row">
                    {{-- Endereço --}}
                    <div class="col-5">
                        <div class="input-group input-group-static my-3 {{ $errors->has('endereco') ? ' is-invalid' : '' }}">
                            <label>{{ __('Endereço') }}</label>
                            <input class="form-control{{ $errors->has('endereco') ? ' is-invalid' : '' }}"
                            name="endereco" id="input-endereco" type="text"
                            value="{{ isset($contrato) ? $contrato->endereco : old('endereco') }}" placeholder="{{ __('Endereço') }}"
                            required="true" aria-required="true"/>
                            @if ($errors->has('endereco'))
                                <span id="endereco-error" class="error text-danger"
                                    for="input-endereco">{{ $errors->first('endereco') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Número --}}
                    <div class="col-2">
                        <div class="input-group input-group-static my-3 {{ $errors->has('numero') ? ' is-invalid' : '' }}">
                            <label>{{ __('Número') }}</label>
                            <input class="form-control{{ $errors->has('numero') ? ' is-invalid' : '' }}"
                            name="numero" id="input-numero" type="text"
                            value="{{ isset($contrato) ? $contrato->numero : old('numero') }}" placeholder="{{ __('Número') }}"
                            required="true" aria-required="true"/>
                            @if ($errors->has('numero'))
                                <span id="numero-error" class="error text-danger"
                                    for="input-numero">{{ $errors->first('numero') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Complemento --}}
                    <div class="col-5">
                        <div class="input-group input-group-static my-3 {{ $errors->has('complemento') ? ' is-invalid' : '' }}">
                            <label>{{ __('Complemento') }}</label>
                            <input class="form-control{{ $errors->has('complemento') ? ' is-invalid' : '' }}"
                            name="complemento" id="input-complemento" type="text"
                            value="{{ isset($contrato) ? $contrato->complemento : old('complemento') }}" placeholder="{{ __('Complemento') }}"
                            />
                            @if ($errors->has('complemento'))
                                <span id="complemento-error" class="error text-danger"
                                    for="input-complemento">{{ $errors->first('complemento') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Bairro --}}
                    <div class="col-5">
                        <div class="input-group input-group-static my-3 {{ $errors->has('bairro') ? ' is-invalid' : '' }}">
                            <label>{{ __('Bairro') }}</label>
                            <input class="form-control{{ $errors->has('bairro') ? ' is-invalid' : '' }}"
                            name="bairro" id="input-bairro" type="text"
                            value="{{ isset($contrato) ? $contrato->bairro : old('bairro') }}" placeholder="{{ __('Bairro') }}"
                            required="true" aria-required="true"/>
                            @if ($errors->has('bairro'))
                                <span id="bairro-error" class="error text-danger"
                                    for="input-bairro">{{ $errors->first('bairro') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Cidade --}}
                    <div class="col-5">
                        <div class="input-group input-group-static my-3 {{ $errors->has('cidade') ? ' is-invalid' : '' }}">
                            <label>{{ __('Cidade') }}</label>
                            <input class="form-control{{ $errors->has('cidade') ? ' is-invalid' : '' }}"
                            name="cidade" id="input-cidade" type="text"
                            value="{{ isset($contrato) ? $contrato->cidade : old('cidade') }}" placeholder="{{ __('Cidade') }}"
                            required="true" aria-required="true"/>
                            @if ($errors->has('cidade'))
                                <span id="cidade-error" class="error text-danger"
                                    for="input-cidade">{{ $errors->first('cidade') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Estado --}}
                    <div class="col-2">
                        <div class="input-group input-group-static my-3 {{ $errors->has('estado') ? ' is-invalid' : '' }}">
                            <label>{{ __('Estado') }}</label>
                            <input class="form-control{{ $errors->has('estado') ? ' is-invalid' : '' }}"
                            name="estado" id="input-estado" type="text"
                            value="{{ isset($contrato) ? $contrato->estado : old('estado') }}" placeholder="{{ __('Estado') }}"
                            required="true" aria-required="true"/>
                            @if ($errors->has('estado'))
                                <span id="estado-error" class="error text-danger"
                                    for="input-estado">{{ $errors->first('estado') }}</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card mb-4">
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 col-lg-12">
				<h4 class="mb-3 bg-light">Veículo(s) do Contrato 
                @if(isset($contrato))
                    <a style="float:right" class="insertRecord btn btn-info btn-sm" data-id="{{ isset($contrato) ? $contrato->idcontrato : old('idcontrato') }}" >+ adicionar item</a>
                @endif
                </h4>

            </div>
            <div class="col-md-12 col-lg-12">
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class='table table-hover table-striped table-bordered table-sm' id="tab_logic">
                                <thead>
                                    <tr class="info" style="font-size:14px;">
                                        <th class="th-sm text-center" >AÇÃO</th>
                                        <th class="w-75">VEÍCULO</th>
                                    </tr>
                                </thead>
                                <tbody class="resultbody">
                                    @if(isset($contratosveiculos))
                                        @foreach ($contratosveiculos as $contratoveiculo)

                                        <tr id="{{ isset($contratoveiculo) ? $contratoveiculo->idcontratoveiculo : old('idcontratoveiculo') }}">
                                                <input class='form-control input-sm'style='width:100%;' type="hidden" name="idcontratoveiculo[]" value="{{ isset($contratoveiculo) ? $contratoveiculo->idcontratoveiculo : old('idcontratoveiculo') }}">
                                                <input class='form-control input-sm'style='width:100%;' type="hidden" name="idcontrato[]" value="{{ isset($contratoveiculo) ? $contratoveiculo->idcontrato : old('idcontrato') }}">
                                                <td class="custom-tbl text-center">
                                                    <a class="deleteRecord btn-sm text-danger material-icons text-sm me-2" data-id="{{ $contratoveiculo->idcontratoveiculo }}" style="cursor: pointer;" >delete</a>
                                                </td>
                                                <td class="custom-tbl">
                                                <select class="form-control input-sm" name="idveiculo[]" onchange="getSelectedValue(this)" required="true" aria-required="true">
                                                    <option value="">- Selecionar -</option>
                                                    @foreach($veiculos as $veiculo)
                                                        <option value="{{ $veiculo->idveiculo }}" 
                                                                {{ ((isset($contratoveiculo) && $veiculo->idveiculo == $contratoveiculo->idveiculo) || (old('idveiculo') == $veiculo->idveiculo)) ? 'selected' : '' }}>{{$veiculo->marca}}/{{$veiculo->modelo}} | {{$veiculo->placa}}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </td>
                                        </tr>
                                        @endforeach 
                                    @endif               
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@if(isset($contrato))
    @include('partials.upload', ['model' => $contrato])
@endif
@include('partials.status', ['model' => $contrato ?? null])


<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($contrato) ? 'Atualizar' : 'Adicionar').' Contrato') }}</button>
        <a href="{{ route('admin.contratos.index') }}"
                   class="btn btn-light">{{ __('Voltar') }}</a>
    </div>
</div>
@push('js')
{{-- @TODO: criar mascaras --}}
{{-- Select2 --}}
    <script src="{{ asset('assets/js/plugins/select2.min.js') }}"></script>
    <script>
        $('.select2').select2();
    
            $(document).on("click", ".deleteRecord", function(){
                var id = $(this).data("id");
                var token = $("meta[name='csrf-token']").attr("content");
                $.ajax({
                    url: "../../contratoveiculo/"+id,
                    type: 'DELETE',
                    data: {
                        "id": id,
                        "_token": token,
                    },
                    success: function (){
                        console.log("it Works");
                        var row = $('#'+id).remove();
                    }
                    });
                });


                $(".insertRecord").click(function(){
                var id = $(this).data("id");
                var token = $("meta[name='csrf-token']").attr("content");
                $.ajax({
                    url: "../../contratoveiculoadd/"+id,
                    type: 'POST',
                    data: {
                        "id": id,
                        "_token": token,
                    },
                    success: function (response){
                        console.log("it Works");
                        var idContratoVeiculo = response.success;
                        var tr = montaHtml(idContratoVeiculo);
                        $('#tab_logic').append(tr);
                        
                    }
                    });
                });
            

            function montaHtml(idcontratoveiculo){
                var trHTML = '<tr id="'+idcontratoveiculo+'">' +
                                    '<input class="form-control input-sm" style="width:100%;" type="hidden" name="idcontratoveiculo[]" value="'+idcontratoveiculo+'" onfocus="focused(this)" onfocusout="defocused(this)">' +
                                    '<input class="form-control input-sm" style="width:100%;" type="hidden" name="idcontrato[]" value="28" onfocus="focused(this)" onfocusout="defocused(this)">' +
                                '<td class="custom-tbl text-center">' +
                                    '<a class="deleteRecord btn-sm text-danger material-icons text-sm me-2" data-id="'+idcontratoveiculo+'" style="cursor: pointer;">delete</a>' +
                                '</td>' +
                                '<td class="custom-tbl">' +
                                    '<select class="form-control input-sm" name="idveiculo[]" onchange="getSelectedValue(this)" required="true" aria-required="true">' +
                                        '<option value="">- Selecionar -</option><?=$opt;?>'+
                                    '</select>' +
                                '</td>' +
                            '</tr>';
                return trHTML;
            }
                
       
    
    </script>

    @include('partials.upload-js')
@endpush