@php
    use Carbon\Carbon;
@endphp
<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage="eventos"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg ">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Eventos"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Eventos</h5>
                            </div>
                        </div>
                        <form action="{{ route('admin.eventos.search') }}" class="navbar-form mt-3" method="get">
                            <div class="row m-0">
                                <div class="col-6 text-left">
                                    <div class="input-group input-group-outline d-flex align-items-center">
                                        <input type="text" name="search" class="form-control"
                                            placeholder="Buscar pelo nome da empresa..."
                                            value="{{ \Request::get('search') }}">
                                        
                                    </div>
                                </div>
                                <div class="col-2 text-left">
                                    <div class="input-group input-group-outline d-flex align-items-center">
                                        <div class="input-group">
                                            <input type="text"  name="date_range" id="date_range" class="form-control" value="{{ $dateRange ?? '' }}" placeholder="Selecione um intervalo de datas" autocomplete="off">
                                            <div class="input-group-append">
                                                <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="col-1 text-left">
                                    <button type="submit" class="btn btn-primary btn-round btn-just-icon m-0">
                                        <i class="material-icons">search</i>
                                        <div class="ripple-container"></div>
                                    </button>
                                </div>
                                <div class="col-3 text-end">
                                    <a class="btn bg-gradient-dark mb-0" href="{{ route('admin.eventos.create') }}"><i
                                            class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar evento</a>
                                </div>
                            </div>
                        </form>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                ID
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Cliente
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Tipo
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Evento
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-center">
                                                Início
                                            </th>
                                           
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-center">
                                                Fim
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-center">
                                                Duração
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-center">
                                                Qtd
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Status
                                            </th>
                                            <th class="text-secondary opacity-7"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($eventos as $evento)
                                            <tr>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ $evento->idevento }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">
                                                                <span class="badge badge-sm bg-gradient-success" style="background: {{ $evento->cliente->cor ?? '' }} ">{{ $evento->cliente->razaosocial ?? 'Sem empresa' }}</span>
                                                            
                                                            </p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">{{ $evento->eventotipo->eventotipo }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <p class="mb-0 text-sm">
                                                                {{ $evento->evento  }}
                                                            
                                                            </p>
                                                        </div>
                                                    </div>
                                                </td>
                                                
                                                <td>
                                                    <div class="d-flex flex-column text-center">
                                                    <p class="mb-0 text-sm">{{ Carbon::parse($evento->data)->format('d/m/y') }} {{ ($evento->eventotipo->hora == 'SIM') ? Carbon::parse($evento->hora)->format('h:i') : '' }}</p>
                                                    </div>
                                                </td>

                                                <td>
                                                    <div class="d-flex flex-column text-center">
                                                    <p class="mb-0 text-sm">{{ Carbon::parse($evento->datafim)->format('d/m/y') }} {{ ($evento->eventotipo->hora == 'SIM') ? Carbon::parse($evento->horafim)->format('h:i') : '' }}</p>
                                                    </div>
                                                </td>

                                                @php
                                                   

                                                    // Combine data e hora:
                                                    $startDateTime = Carbon::parse($evento->data . ' ' . $evento->hora);

                                                    // Combine datafim e horafim:
                                                    $endDateTime = Carbon::parse($evento->datafim . ' ' . $evento->horafim);

                                                    // Calcule a diferença:
                                                    $duration = $startDateTime->diff($endDateTime);

                                                    // Verifique se a diferença é maior que 1 dia:
                                                    if ($duration->days > 1) {
                                                        if($evento->eventotipo->hora == 'SIM'){
                                                            // Formate a diferença para mostrar em dias, horas, minutos, etc.:
                                                            $durationString = $duration->format('%d dias %H:%I');
                                                        }else{
                                                            // Formate a diferença para mostrar em dias, horas, minutos, etc.:
                                                            $durationString = $duration->format('%d dias');
                                                        }
                                                        
                                                    } else {
                                                        // Formate a diferença para mostrar apenas horas e minutos:
                                                        $durationString = $duration->format('%H:%I');
                                                    }
                                                @endphp
                                                </td>
                                                <td>
                                                    <div class="d-flex flex-column text-center">
                                                    <p class="mb-0 text-sm">{{ $durationString }}</p>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex flex-column text-center">
                                                    <p class="mb-0 text-sm">{{ $evento->qtd }}</p>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex px-2 py-1">
                                                        <div class="d-flex flex-column justify-content-center">
                                                            <span class="badge badge-sm 
                                                            @if ($evento->status == 'ATIVO')
                                                                bg-success
                                                            @elseif ($evento->status == 'INATIVO')
                                                                bg-danger
                                                            @else
                                                                bg-info
                                                            @endif">
                                                            {{ $evento->status }}
                                                        </span>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="align-middle text-center">
                                                    <a rel="tooltip" class="btn btn-success btn-sm btn-link"
                                                        href="{{route('admin.eventos.edit', $evento->idevento)}}" data-original-title=""
                                                        title="">
                                                        <i class="material-icons">edit</i>
                                                        <div class="ripple-container"></div>
                                                    </a>
                                                    <form action="{{route('admin.eventos.destroy', $evento->idevento)}}" class="d-inline" method="POST">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="button" class="btn btn-danger btn-sm btn-link"
                                                            data-original-title="" title=""
                                                            onclick="confirm('{{ __('Você tem certeza que deseja apagar esse Evento ?') }}') ? this.parentElement.submit() : ''">
                                                            <i class="material-icons">close</i>
                                                            <div class="ripple-container"></div>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
</x-layout>
