<!-- EventoTipo View -->
<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Tipos de Evento</h5>
        </div>
    </div>
    <div class="card-body ">
        <!-- Mensagens da session -->
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
        @endif

        <div class="row">
            @if (isset($eventoTipo))
            <div class="col-md-9 col-lg-9"> 
                <span class="badge badge-sm bg-light mb-3 text-dark"># {{$eventoTipo->ideventotipo}}</span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{ $bg_status }}">{{ $eventoTipo->status }}</span>
            </div>
            @endif
        </div>
    </div>
</div>
<div class="card mb-4">
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
            </div>
            <!-- Empresa -->
            <div class="col-8">
                <div class="input-group input-group-static my-3">
                    <label class="ms-0">Empresa</label>
                    <select class="form-control" name="idempresa">
                        <option value="" disabled="disabled">- Selecionar -</option>
                        @foreach($empresas as $empresa)
                            <option value="{{ $empresa->idempresa }}" {{ ((isset($eventoTipo) && $empresa->idempresa == $eventoTipo->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <!-- Tipo de Evento -->
            <div class="col-8">
                <div class="input-group input-group-static my-3 {{ $errors->has('eventotipo') ? ' is-invalid' : '' }}">
                    <label>Nome do Tipo de Evento</label>
                    <input class="form-control {{ $errors->has('eventotipo') ? ' is-invalid' : '' }}" name="eventotipo" id="input-eventotipo" type="text" value="{{ isset($eventoTipo) ? $eventoTipo->eventotipo : old('eventotipo') }}" required="true" aria-required="true"/>
                    @if ($errors->has('eventotipo'))
                        <span id="eventotipo-error" class="error text-danger" for="input-eventotipo">{{ $errors->first('eventotipo') }}</span>
                    @endif
                </div>
            </div>
            <!-- Descrição -->
            <div class="col-12">
                <div class="input-group input-group-static my-3 {{ $errors->has('descricao') ? ' is-invalid' : '' }}">
                    <label>Descrição</label>
                    <textarea class="form-control {{ $errors->has('descricao') ? ' is-invalid' : '' }}" name="descricao" id="input-descricao" rows="3">{{ isset($eventoTipo) ? $eventoTipo->descricao : old('descricao') }}</textarea>
                    @if ($errors->has('descricao'))
                        <span id="descricao-error" class="error text-danger" for="input-descricao">{{ $errors->first('descricao') }}</span>
                    @endif
                </div>
            </div>
             <!-- Veículos -->
             <div class="col-3">
                <div class="input-group input-group-static my-3">
                    <label>Veículos</label>
                    <select class="form-control" name="veiculo">
                        <option value="SIM" {{ (isset($eventoTipo) && $eventoTipo->veiculo == 'SIM') ? 'selected' : '' }}>Sim</option>
                        <option value="NAO" {{ (isset($eventoTipo) && $eventoTipo->veiculo == 'NAO') ? 'selected' : '' }}>Não</option>
                    </select>
                </div>
            </div>
             <!-- Pessoa -->
             <div class="col-3">
                <div class="input-group input-group-static my-3">
                    <label>Colaborador</label>
                    <select class="form-control" name="pessoa">
                        <option value="SIM" {{ (isset($eventoTipo) && $eventoTipo->pessoa == 'SIM') ? 'selected' : '' }}>Sim</option>
                        <option value="NAO" {{ (isset($eventoTipo) && $eventoTipo->pessoa == 'NAO') ? 'selected' : '' }}>Não</option>
                    </select>
                </div>
            </div>
             <!-- Qtd -->
             <div class="col-3">
                <div class="input-group input-group-static my-3">
                    <label>Qtd</label>
                    <select class="form-control" name="qtd">
                        <option value="SIM" {{ (isset($eventoTipo) && $eventoTipo->qtd == 'SIM') ? 'selected' : '' }}>Sim</option>
                        <option value="NAO" {{ (isset($eventoTipo) && $eventoTipo->qtd == 'NAO') ? 'selected' : '' }}>Não</option>
                    </select>
                </div>
            </div>
             <!-- Hora -->
             <div class="col-3">
                <div class="input-group input-group-static my-3">
                    <label>Hora</label>
                    <select class="form-control" name="hora">
                        <option value="SIM" {{ (isset($eventoTipo) && $eventoTipo->hora == 'SIM') ? 'selected' : '' }}>Sim</option>
                        <option value="NAO" {{ (isset($eventoTipo) && $eventoTipo->hora == 'NAO') ? 'selected' : '' }}>Não</option>
                    </select>
                </div>
            </div>
            <!-- Tipo de Evento -->
            <div class="col-3">
                <div class="input-group input-group-static my-3 {{ $errors->has('datapadrao') ? ' is-invalid' : '' }}">
                    <label>Data Padrão(D+)</label>
                    <input class="form-control {{ $errors->has('datapadrao') ? ' is-invalid' : '' }}" name="datapadrao" id="input-datapadrao" type="text" value="{{ isset($eventoTipo) ? $eventoTipo->datapadrao : old('datapadrao') }}" required="true" aria-required="true"/>
                    @if ($errors->has('datapadrao'))
                        <span id="datapadrao-error" class="error text-danger" for="input-datapadrao">{{ $errors->first('datapadrao') }}</span>
                    @endif
                </div>
            </div>
               <!-- Tipo de Evento -->
               <div class="col-3">
                <div class="input-group input-group-static my-3 {{ $errors->has('horapadrao') ? ' is-invalid' : '' }}">
                    <label>Hora Padrão (H+)</label>
                    <input class="form-control {{ $errors->has('horapadrao') ? ' is-invalid' : '' }}" name="horapadrao" id="input-horapadrao" type="text" value="{{ isset($eventoTipo) ? $eventoTipo->horapadrao : old('horapadrao') }}" required="true" aria-required="true"/>
                    @if ($errors->has('horapadrao'))
                        <span id="horapadrao-error" class="error text-danger" for="input-horapadrao">{{ $errors->first('horapadrao') }}</span>
                    @endif
                </div>
            </div>
             <!-- Hora -->
             <div class="col-3">
                <div class="input-group input-group-static my-3">
                    <label>Venda</label>
                    <select class="form-control" name="venda">
                        <option value="SIM" {{ (isset($eventoTipo) && $eventoTipo->venda == 'SIM') ? 'selected' : '' }}>Sim</option>
                        <option value="NAO" {{ (isset($eventoTipo) && $eventoTipo->venda == 'NAO') ? 'selected' : '' }}>Não</option>
                    </select>
                </div>
            </div>
            <!-- Status -->
            <div class="col-3">
                <div class="input-group input-group-static my-3">
                    <label>Status</label>
                    <select class="form-control" name="status">
                        <option value="ATIVO" {{ (isset($eventoTipo) && $eventoTipo->status == 'ATIVO') ? 'selected' : '' }}>ATIVO</option>
                        <option value="INATIVO" {{ (isset($eventoTipo) && $eventoTipo->status == 'INATIVO') ? 'selected' : '' }}>INATIVO</option>
                    </select>
                </div>
            </div>
            <!-- Produto-Serviço -->
            <div class="col-3">
                <div class="input-group input-group-static my-3">
                    <label class="ms-0">Produto/Serviço Vinculado</label>
                    <select class="form-control" name="idprodserv">
                        <option value="" >- Selecionar -</option>
                        @foreach($prodservs as $prodserv)
                            <option value="{{ $prodserv->idprodserv }}" {{ ((isset($eventoTipo) && $prodserv->idprodserv == $eventoTipo->idprodserv) || (old('idprodserv') == $prodserv->idprodserv)) ? 'selected' : '' }}>{{$prodserv->prodservtipo->prodservtipo}} / {{$prodserv->prodserv}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success">{{ __(isset($eventoTipo) ? 'Atualizar' : 'Adicionar') . ' Tipo de Evento' }}</button>
        <a href="{{ route('admin.eventotipos.index') }}" class="btn btn-light">{{ __('Voltar') }}</a>
        @if(isset($eventoTipo))
        <a class="btn bg-gradient-dark" href="{{route('admin.eventotipos.create')}}"><i
                    class="material-icons text-sm">add</i>&nbsp;&nbsp;Novo Tipo Eventos</a>
        @endif
    </div>
</div>

@push('js')
    @include('partials.upload-js')
@endpush
