<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage="{{$tipo}}"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg ">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Fornecedores"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-md-12">
                    <form method="post" action="{{ route('admin.pessoas.store') }}" autocomplete="off"
                    class="form-horizontal" enctype="multipart/form-data" id="formPrincipal">
                        @csrf
                        @method('post')

                        <div class="card ">
                            <div class="card-header card-header-primary">
                                <h4 class="card-title">{{ __(isset($pessoa) ? 'Atualizar pessoa' : 'Adicionar nova Pessoa') }}</h4>
                                <p class="card-category"></p>
                            </div>
                            <div class="card-body ">
                                <div class="row">
                                    <div class="col-md-12 text-right">
                                        <a href="{{ route('admin.pessoas.index', ['tipo' => $tipo]) }}"
                                            class="btn btn-sm btn-primary">{{ __('Voltar para a lista') }}</a>
                                    </div>
                                </div>
                                @include('admin.pessoas._form', ['tipo' => 'F'])
                            </div>
                            <div class="card-footer ml-auto mr-auto">
                                <button type="submit"
                                    class="btn btn-primary">{{ __(isset($pessoa) ? 'Atualizar Pessoa' : 'Adicionar Pessoa') }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </main>
</x-layout>

<style>
    .ck-editor__editable_inline {
        min-height: 200px;
    }
</style>

@push('js')
    @include('partials.upload-js')
@endpush