<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Funcionário</h5>
        </div>
    </div>
    <div class="card-body ">
    {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
            @endif

        <div class="row">
            @if (isset($funcionario))
            <div class="col-md-9 col-lg-9"> 
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$funcionario->idpessoa;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{$bg_status}}"><?=$funcionario->status;?></span>
            </div>
        @endif
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            {{-- Empresa --}}
                            <div class="col-8">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Empresa</label>
                                    <select class="form-control" name="idempresa">
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                        @foreach ($empresas as $empresa)
                                            <option value="{{ $empresa->idempresa }}"
                                                {{ (isset($funcionario) && $empresa->idempresa == $funcionario->empresa->idempresa) || old('idempresa') == $empresa->idempresa ? 'selected' : '' }}>
                                                {{ $empresa->razaosocial }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            {{-- Nome --}}
                            <div class="col-8">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('nome') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Nome') }}</label>
                                    <input class="form-control{{ $errors->has('nome') ? ' is-invalid' : '' }}" name="nome"
                                        id="input-nome" type="text"
                                        value="{{ isset($funcionario) ? $funcionario->nome : old('nome') }}"
                                        placeholder="{{ __('Nome') }}" required="true" aria-required="true" />
                                    @if ($errors->has('nome'))
                                        <span id="nome-error" class="error text-danger"
                                            for="input-nome">{{ $errors->first('nome') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            {{-- CPF  --}}
                            <div class="col-3">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('cpfcnpj') ? ' is-invalid' : '' }}">
                                    <label>{{ __('CPF') }}</label>
                                    <input class="form-control cpf {{ $errors->has('cpfcnpj') ? ' is-invalid' : '' }}"
                                        name="cpfcnpj" id="input-cpfcnpj" type="text"
                                        value="{{ isset($funcionario) ? $funcionario->cpfcnpj : old('cpfcnpj') }}"
                                        placeholder="{{ __('CPF') }}" required="true" aria-required="true" />
                                    @if ($errors->has('cpfcnpj'))
                                        <span id="cpfcnpj-error" class="error text-danger"
                                            for="input-cpfcnpj">{{ $errors->first('cpfcnpj') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Data de nascimento --}}
                            <div class="col-3">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('datanascimento') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Data de nascimento') }}</label>
                                    <input class="form-control data {{ $errors->has('datanascimento') ? ' is-invalid' : '' }}"
                                        name="datanascimento" id="input-datanascimento" type="text"
                                        value="{{ isset($funcionario) ? $funcionario->datanascimento : old('datanascimento') }}"
                                        placeholder="{{ __('Data de nascimento') }}" required="true" aria-required="true" />
                                    @if ($errors->has('datanascimento'))
                                        <span id="datanascimento-error" class="error text-danger"
                                            for="input-datanascimento">{{ $errors->first('datanascimento') }}</span>
                                    @endif
                                </div>  
                            </div>
                            {{-- RG --}}
                            <div class="col-3">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('rg') ? ' is-invalid' : '' }}">
                                    <label>{{ __('RG') }}</label>
                                    <input class="form-control{{ $errors->has('rg') ? ' is-invalid' : '' }}" name="rg"
                                        id="input-rg" type="text"
                                        value="{{ isset($funcionario) ? $funcionario->rg : old('rg') }}"
                                        placeholder="{{ __('RG') }}" required="true" aria-required="true" />
                                    @if ($errors->has('rg'))
                                        <span id="rg-error" class="error text-danger"
                                            for="input-rg">{{ $errors->first('rg') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Estado civil --}}
                            <div class="col-3">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Estado civil</label>
                                    <select class="form-control" name="estadocivil">
                                        <option value="">Selecionar</option>
                                        <option value="solteiro"
                                            {{ (isset($funcionario) && $funcionario->estadocivil == 'solteiro') || old('status') == 'solteiro' ? 'selected' : '' }}>
                                            Solteiro</option>
                                        <option value="casado"
                                            {{ (isset($funcionario) && $funcionario->estadocivil == 'casado') || old('status') == 'casado' ? 'selected' : '' }}>
                                            Casado</option>
                                    </select>
                                </div>
                            </div>
                            {{-- Nome do pai --}}
                            <div class="col-8">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('nomepai') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Nome do pai') }}</label>
                                    <input class="form-control{{ $errors->has('nomepai') ? ' is-invalid' : '' }}"
                                        name="nomepai" id="input-nomepai" type="text"
                                        value="{{ isset($funcionario) ? $funcionario->nomepai : old('nomepai') }}"
                                        placeholder="{{ __('Nome do pai') }}" required="true" aria-required="true" />
                                    @if ($errors->has('nomepai'))
                                        <span id="nomepai-error" class="error text-danger"
                                            for="input-nomepai">{{ $errors->first('nomepai') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Nome da mãe --}}
                            <div class="col-8">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('nomemae') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Nome da mãe') }}</label>
                                    <input class="form-control{{ $errors->has('nomemae') ? ' is-invalid' : '' }}"
                                        name="nomemae" id="input-nomemae" type="text"
                                        value="{{ isset($funcionario) ? $funcionario->nomemae : old('nomemae') }}"
                                        placeholder="{{ __('Nome da mãe') }}" required="true" aria-required="true" />
                                    @if ($errors->has('nomemae'))
                                        <span id="nomemae-error" class="error text-danger"
                                            for="input-nomemae">{{ $errors->first('nomemae') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="row"> 
                            {{-- Telefone Fixo --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('telefone') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Telefone Fixo') }}</label>
                                    <input class="form-control telefone {{ $errors->has('telefone') ? ' is-invalid' : '' }}"
                                        name="telefone" id="input-telefone" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->telefone : old('telefone') }}"
                                        placeholder="{{ __('Telefone Fixo') }}"  />
                                    @if ($errors->has('telefone'))
                                        <span id="telefone-error" class="error text-danger"
                                            for="input-telefone">{{ $errors->first('telefone') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Telefone Celular --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('celular') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Telefone Celular') }}</label>
                                    <input class="form-control telefone {{ $errors->has('celular') ? ' is-invalid' : '' }}"
                                        name="celular" id="input-celular" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->celular : old('celular') }}"
                                        placeholder="{{ __('Telefone Celular') }}"  />
                                    @if ($errors->has('celular'))
                                        <span id="celular-error" class="error text-danger"
                                            for="input-celular">{{ $errors->first('celular') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Telefone Celular2 --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('celular2') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Telefone Celular2') }}</label>
                                    <input class="form-control telefone {{ $errors->has('celular2') ? ' is-invalid' : '' }}"
                                        name="celular2" id="input-celular2" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->celular2 : old('celular2') }}"
                                        placeholder="{{ __('Telefone Celular2') }}"  />
                                    @if ($errors->has('celular2'))
                                        <span id="celular2-error" class="error text-danger"
                                            for="input-celular2">{{ $errors->first('celular2') }}</span>
                                    @endif
                                </div>
                            </div> 
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Informações Adicionais</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                    <div class="row">
                            {{-- Cargo --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('cargo') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Cargo') }}</label>
                                    <input class="form-control{{ $errors->has('cargo') ? ' is-invalid' : '' }}"
                                        name="cargo" id="input-cargo" type="text"
                                        value="{{ isset($funcionario) ? $funcionario->cargo : old('cargo') }}"
                                        placeholder="{{ __('Cargo') }}" required="true" aria-required="true" />
                                    @if ($errors->has('cargo'))
                                        <span id="cargo-error" class="error text-danger"
                                            for="input-cargo">{{ $errors->first('cargo') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- E-Social --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('esocial') ? ' is-invalid' : '' }}">
                                    <label>{{ __('E-Social') }}</label>
                                    <input class="form-control{{ $errors->has('esocial') ? ' is-invalid' : '' }}"
                                        name="esocial" id="input-esocial" type="text"
                                        value="{{ isset($funcionario) ? $funcionario->esocial : old('esocial') }}"
                                        placeholder="{{ __('E-Social') }}" required="true" aria-required="true" />
                                    @if ($errors->has('cargo'))
                                        <span id="esocial-error" class="error text-danger"
                                            for="input-esocial">{{ $errors->first('esocial') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            {{-- Admissão --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('admissao') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Admissão') }}</label>
                                    <input class="form-control{{ $errors->has('admissao') ? ' is-invalid' : '' }}"
                                        name="admissao" id="input-admissao" type="date"
                                        value="{{ isset($funcionario) ? $funcionario->admissao : old('admissao') }}"
                                        placeholder="{{ __('Admissão') }}" required="true" aria-required="true" />
                                    @if ($errors->has('admissao'))
                                        <span id="admissao-error" class="error text-danger"
                                            for="input-admissao">{{ $errors->first('admissao') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Motivo da admissão --}}
                            <div class="col-8">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Motivo da Admissão</label>
                                    <select class="form-control" name="admissaomotivo">
                                        <option value="">- Selecionar -</option>
                                        @foreach($admissaomotivo as $key => $admmotivo)
                                            <option value="{{ $key }}" {{ ((isset($funcionario) && $key == $funcionario->admissaomotivo) || (old('admmotivo') == $key)) ? 'selected' : '' }}>{{$admmotivo}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            {{-- Demissão --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('demissao') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Demissão') }}</label>
                                    <input class="form-control{{ $errors->has('demissao') ? ' is-invalid' : '' }}"
                                        name="demissao" id="input-demissao" type="date"
                                        value="{{ isset($funcionario) ? $funcionario->demissao : old('demissao') }}"
                                        placeholder="{{ __('Admissão') }}"  />
                                    @if ($errors->has('demissao'))
                                        <span id="demissao-error" class="error text-danger"
                                            for="input-demissao">{{ $errors->first('demissao') }}</span>
                                    @endif
                                </div>
                            </div>
                            
                            {{-- Motivo Demissão --}}
                            <div class="col-8">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Motivo da Demissão</label>
                                    <select class="form-control" name="demissaomotivo">
                                        <option value="">- Selecionar -</option>
                                        @foreach($demissaomotivo as $key => $demmotivo)
                                            <option value="{{ $key }}" {{ ((isset($funcionario) && $key == $funcionario->demissaomotivo) || (old('demmotivo') == $key)) ? 'selected' : '' }}>{{$demmotivo}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>	
                            {{-- Tipo --}}
                            <input type="hidden" name="tipo" value="F" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Endereço</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            {{-- Cep --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('cep') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Cep') }}</label>
                                    <input class="form-control cep {{ $errors->has('cep') ? ' is-invalid' : '' }}"
                                        name="cep" id="input-cep" type="text"
                                        value="{{ isset($funcionario) ? $funcionario->cep : old('cep') }}"
                                        placeholder="{{ __('Cep') }}" required="true" aria-required="true" />
                                    @if ($errors->has('cep'))
                                        <span id="cep-error" class="error text-danger"
                                            for="input-cep">{{ $errors->first('cep') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            {{-- Endereço --}}
                            <div class="col-5">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('endereco') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Endereço') }}</label>
                                    <input class="form-control{{ $errors->has('endereco') ? ' is-invalid' : '' }}"
                                        name="endereco" id="input-endereco" type="text"
                                        value="{{ isset($funcionario) ? $funcionario->endereco : old('endereco') }}"
                                        placeholder="{{ __('Endereço') }}" required="true" aria-required="true" />
                                    @if ($errors->has('endereco'))
                                        <span id="endereco-error" class="error text-danger"
                                            for="input-endereco">{{ $errors->first('endereco') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Número --}}
                            <div class="col-2">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('numero') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Número') }}</label>
                                    <input class="form-control{{ $errors->has('numero') ? ' is-invalid' : '' }}" name="numero"
                                        id="input-numero" type="text"
                                        value="{{ isset($funcionario) ? $funcionario->numero : old('numero') }}"
                                        placeholder="{{ __('Número') }}" required="true" aria-required="true" />
                                    @if ($errors->has('numero'))
                                        <span id="numero-error" class="error text-danger"
                                            for="input-numero">{{ $errors->first('numero') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Complemento --}}
                            <div class="col-5">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('complemento') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Complemento') }}</label>
                                    <input class="form-control{{ $errors->has('complemento') ? ' is-invalid' : '' }}"
                                        name="complemento" id="input-complemento" type="text"
                                        value="{{ isset($funcionario) ? $funcionario->complemento : old('complemento') }}"
                                        placeholder="{{ __('Complemento') }}"  />
                                    @if ($errors->has('complemento'))
                                        <span id="complemento-error" class="error text-danger"
                                            for="input-complemento">{{ $errors->first('complemento') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            {{-- Bairro --}}
                            <div class="col-5">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('bairro') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Bairro') }}</label>
                                    <input class="form-control{{ $errors->has('bairro') ? ' is-invalid' : '' }}"
                                        name="bairro" id="input-bairro" type="text"
                                        value="{{ isset($funcionario) ? $funcionario->bairro : old('bairro') }}"
                                        placeholder="{{ __('Bairro') }}" required="true" aria-required="true" />
                                    @if ($errors->has('bairro'))
                                        <span id="bairro-error" class="error text-danger"
                                            for="input-bairro">{{ $errors->first('bairro') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Cidade --}}
                            <div class="col-5">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('cidade') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Cidade') }}</label>
                                    <input class="form-control{{ $errors->has('cidade') ? ' is-invalid' : '' }}"
                                        name="cidade" id="input-cidade" type="text"
                                        value="{{ isset($funcionario) ? $funcionario->cidade : old('cidade') }}"
                                        placeholder="{{ __('Cidade') }}" required="true" aria-required="true" />
                                    @if ($errors->has('cidade'))
                                        <span id="cidade-error" class="error text-danger"
                                            for="input-cidade">{{ $errors->first('cidade') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Estado --}}
                            <div class="col-2">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('estado') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Estado') }}</label>
                                    <input class="form-control{{ $errors->has('estado') ? ' is-invalid' : '' }}"
                                        name="estado" id="input-estado" type="text"
                                        value="{{ isset($funcionario) ? $funcionario->estado : old('estado') }}"
                                        placeholder="{{ __('Estado') }}" required="true" aria-required="true" />
                                    @if ($errors->has('estado'))
                                        <span id="estado-error" class="error text-danger"
                                            for="input-estado">{{ $errors->first('estado') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
        


<div class="row">
    <div class="col-md-6">
        @include('partials.status', ['model' => $funcionario ?? null])
    </div>
    @if(isset($funcionario))
    <div class="col-md-6">
        @include('partials.upload', ['model' => $funcionario])
    </div>
    @endif
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-footer ml-auto mr-auto">
                <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($funcionario) ? 'Atualizar' : 'Adicionar').' Funcionário') }}</button>
                <a href="{{ route('admin.funcionarios.index') }}"
                        class="btn btn-light">{{ __('Voltar') }}</a>
            </div>
        </div>
    </div>
</div>
@push('js')
    @include('partials.upload-js')
@endpush