<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">{{ ucfirst($tipo) }}</h5>
        </div>
    </div>
    <div class="card-body ">
    {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
            @endif

        <div class="row">
            @if (isset($pessoa))
            <div class="col-md-9 col-lg-9"> 
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$pessoa->idpessoa;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{$bg_status}}"><?=$pessoa->status;?></span>
            </div>
        @endif
        </div>
    </div>
</div>
<div class="row">
<div class="col-md-12">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            {{-- Empresa --}}
                            <div class="col-8">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Empresa</label>
                                    <select class="form-control" name="idempresa">
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                        @foreach ($empresas as $empresa)
                                            <option value="{{ $empresa->idempresa }}"
                                                {{ (isset($pessoa) && $empresa->idempresa == $pessoa->empresa->idempresa) || old('idempresa') == $empresa->idempresa ? 'selected' : '' }}>
                                                {{ $empresa->razaosocial }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            {{-- Nome --}}
                            <div class="col-6">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('nome') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Nome') }}</label>
                                    <input class="form-control{{ $errors->has('nome') ? ' is-invalid' : '' }}" name="nome"
                                        id="input-nome" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->nome : old('nome') }}"
                                        placeholder="{{ __('Nome') }}" required="true" aria-required="true" />
                                    @if ($errors->has('nome'))
                                        <span id="nome-error" class="error text-danger"
                                            for="input-nome">{{ $errors->first('nome') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Tipo --}}
                            <input type="hidden" value="{{ $tipo }}" name="tipo" />
                            {{-- <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('idtipopessoa') ? ' is-invalid' : '' }}">
                                    <label class="ms-0">{{ __('Tipo') }}</label>
                                    <select class="form-control" name="idtipopessoa">
                                        <option value="">Selecionar</option>
                                        @foreach ($tipoPessoa as $tipo)
                                            <option value="{{ $tipo->idtipopessoa }}" {{ ((isset($pessoa) ) || (old('idtipopessoa') == $tipo->idtipopessoa)) ? 'selected' : '' }}>{{ $tipo->tipopessoa }}</option>
                                        @endforeach
                                    </select>
                                    @if ($errors->has('idtipopessoa'))
                                        <span id="idtipopessoa-error" class="error text-danger"
                                            for="input-idtipopessoa">{{ $errors->first('idtipopessoa') }}</span>
                                    @endif
                                </div>
                            </div> --}}
                            {{-- Razão social --}}

                            <div class="col-6">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('razaosocial') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Razão social') }}</label>
                                    <input class="form-control{{ $errors->has('razaosocial') ? ' is-invalid' : '' }}"
                                        name="razaosocial" id="input-razaosocial" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->razaosocial : old('razaosocial') }}"
                                        placeholder="{{ __('Razão social') }}"  />
                                    @if ($errors->has('razaosocial'))
                                        <span id="razaosocial-error" class="error text-danger"
                                            for="input-razaosocial">{{ $errors->first('razaosocial') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            {{-- CPF / CNPJ --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('cpfcnpj') ? ' is-invalid' : '' }}">
                                    <label>{{ __('CPF / CNPJ') }}</label>
                                    <input class="form-control cpfcnpj {{ $errors->has('cpfcnpj') ? ' is-invalid' : '' }}"
                                        name="cpfcnpj" id="input-cpfcnpj" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->cpfcnpj : old('cpfcnpj') }}"
                                        placeholder="{{ __('CPF / CNPJ') }}"  />
                                    @if ($errors->has('cpfcnpj'))
                                        <span id="cpfcnpj-error" class="error text-danger"
                                            for="input-cpfcnpj">{{ $errors->first('cpfcnpj') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- RG --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('rg') ? ' is-invalid' : '' }}">
                                    <label>{{ __('RG') }}</label>
                                    <input class="form-control{{ $errors->has('rg') ? ' is-invalid' : '' }}" name="rg"
                                        id="input-rg" type="text" value="{{ isset($pessoa) ? $pessoa->rg : old('rg') }}"
                                        placeholder="{{ __('RG') }}"  />
                                    @if ($errors->has('rg'))
                                        <span id="rg-error" class="error text-danger"
                                            for="input-rg">{{ $errors->first('rg') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Inscrição estadual --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('inscestadual') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Inscrição Estadual') }}</label>
                                    <input class="form-control{{ $errors->has('inscestadual') ? ' is-invalid' : '' }}"
                                        name="inscestadual" id="input-inscestadual" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->inscestadual : old('inscestadual') }}"
                                        placeholder="{{ __('Inscrição Estadual') }}"  />
                                    @if ($errors->has('inscestadual'))
                                        <span id="inscestadual-error" class="error text-danger"
                                            for="input-inscestadual">{{ $errors->first('inscestadual') }}</span>
                                    @endif
                                </div>
                            </div>
                            @if ($tipo != 'fornecedor' and $tipo != 'cliente' )
                            {{-- Data de nascimento --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('datanascimento') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Data de nascimento') }}</label>
                                    <input class="form-control data {{ $errors->has('datanascimento') ? ' is-invalid' : '' }}"
                                        name="datanascimento" id="input-datanascimento" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->datanascimento : old('datanascimento') }}"
                                        placeholder="{{ __('Data de nascimento') }}" required="true" aria-required="true" />
                                    @if ($errors->has('datanascimento'))
                                        <span id="datanascimento-error" class="error text-danger"
                                            for="input-datanascimento">{{ $errors->first('datanascimento') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Estado civil --}}
                            <div class="col-4">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Estado civil</label>
                                    <select class="form-control" name="estadocivil">
                                        <option value="">Selecionar</option>
                                        <option value="solteiro"
                                            {{ (isset($pessoa) && $pessoa->estadocivil == 'solteiro') || old('status') == 'solteiro' ? 'selected' : '' }}>
                                            Solteiro</option>
                                        <option value="casado"
                                            {{ (isset($pessoa) && $pessoa->estadocivil == 'casado') || old('status') == 'casado' ? 'selected' : '' }}>
                                            Casado</option>
                                    </select>
                                </div>
                            </div>
                            @endif
                            {{-- Descrição --}}
                            <div class="col-6">
                                <div class="input-group input-group-static my-3 {{ $errors->has('descricao') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Descrição') }}</label>
                                    <textarea rows="6" class="form-control{{ $errors->has('descricao') ? ' is-invalid' : '' }}"
                                        name="descricao" id="input-descricao">{{ isset($pessoa) ? $pessoa->descricao : old('descricao') }}</textarea>
                                    @if ($errors->has('descricao'))
                                        <span id="descricao-error" class="error text-danger"
                                            for="input-descricao">{{ $errors->first('descricao') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Dados Financeiros --}}
                            <div class="col-6">
                                <div class="input-group input-group-static my-3 {{ $errors->has('observacao') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Dados Financeiros') }}</label>
                                    <textarea rows="6" class="form-control{{ $errors->has('observacao') ? ' is-invalid' : '' }}"
                                        name="observacao" id="input-observacao">{{ isset($pessoa) ? $pessoa->observacao : old('observacao') }}</textarea>
                                    @if ($errors->has('observacao'))
                                        <span id="observacao-error" class="error text-danger"
                                            for="input-observacao">{{ $errors->first('observacao') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Informações de Contato</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                    {{-- Responsável --}}
                            <div class="col-8">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('responsavel') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Responsável') }}</label>
                                    <input class="form-control {{ $errors->has('responsavel') ? ' is-invalid' : '' }}"
                                        name="responsavel" id="input-responsavel" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->responsavel : old('responsavel') }}"
                                        placeholder="{{ __('Responsável') }}"  />
                                    @if ($errors->has('responsavel'))
                                        <span id="responsavel-error" class="error text-danger"
                                            for="input-responsavel">{{ $errors->first('responsavel') }}</span>
                                    @endif
                                </div>
                            </div>

                            {{-- Telefone Fixo --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('telefone') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Telefone Fixo') }}</label>
                                    <input class="form-control telefone {{ $errors->has('telefone') ? ' is-invalid' : '' }}"
                                        name="telefone" id="input-telefone" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->telefone : old('telefone') }}"
                                        placeholder="{{ __('Telefone Fixo') }}"  />
                                    @if ($errors->has('telefone'))
                                        <span id="telefone-error" class="error text-danger"
                                            for="input-telefone">{{ $errors->first('telefone') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Telefone Celular --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('celular') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Telefone Celular') }}</label>
                                    <input class="form-control telefone {{ $errors->has('celular') ? ' is-invalid' : '' }}"
                                        name="celular" id="input-celular" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->celular : old('celular') }}"
                                        placeholder="{{ __('Telefone Celular') }}"  />
                                    @if ($errors->has('celular'))
                                        <span id="celular-error" class="error text-danger"
                                            for="input-celular">{{ $errors->first('celular') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Telefone Celular2 --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('celular2') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Telefone Celular2') }}</label>
                                    <input class="form-control telefone {{ $errors->has('celular2') ? ' is-invalid' : '' }}"
                                        name="celular2" id="input-celular2" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->celular2 : old('celular2') }}"
                                        placeholder="{{ __('Telefone Celular2') }}"  />
                                    @if ($errors->has('celular2'))
                                        <span id="celular2-error" class="error text-danger"
                                            for="input-celular2">{{ $errors->first('celular2') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Website --}}
                            <div class="col-6">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('website') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Website') }}</label>
                                    <input class="form-control {{ $errors->has('website') ? ' is-invalid' : '' }}"
                                        name="website" id="input-website" type="text"
                                        value="{{ isset($website) ? $pessoa->website : old('website') }}"
                                        placeholder="{{ __('Website') }}"  />
                                    @if ($errors->has('celular'))
                                        <span id="website-error" class="error text-danger"
                                            for="input-website">{{ $errors->first('website') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- E-mail --}}
                            <div class="col-6">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('email') ? ' is-invalid' : '' }}">
                                    <label>{{ __('E-mail') }}</label>
                                    <input class="form-control email {{ $errors->has('email') ? ' is-invalid' : '' }}"
                                        name="email" id="input-email" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->email : old('email') }}"
                                        placeholder="{{ __('E-mail') }}"  />
                                    @if ($errors->has('email'))
                                        <span id="email-error" class="error text-danger"
                                            for="input-email">{{ $errors->first('email') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">


        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Endereço</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            {{-- Cep --}}
                            <div class="col-12">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('cep') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Cep') }}</label>
                                    <input class="form-control cep {{ $errors->has('cep') ? ' is-invalid' : '' }}"
                                        name="cep" id="input-cep" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->cep : old('cep') }}"
                                        placeholder="{{ __('Cep') }}" />
                                    @if ($errors->has('cep'))
                                        <span id="cep-error" class="error text-danger"
                                            for="input-cep">{{ $errors->first('cep') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Endereço --}}
                            <div class="col-5">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('endereco') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Endereço') }}</label>
                                    <input class="form-control{{ $errors->has('endereco') ? ' is-invalid' : '' }}"
                                        name="endereco" id="input-endereco" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->endereco : old('endereco') }}"
                                        placeholder="{{ __('Endereço') }}"  />
                                    @if ($errors->has('endereco'))
                                        <span id="endereco-error" class="error text-danger"
                                            for="input-endereco">{{ $errors->first('endereco') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Número --}}
                            <div class="col-2">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('numero') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Número') }}</label>
                                    <input class="form-control{{ $errors->has('numero') ? ' is-invalid' : '' }}"
                                        name="numero" id="input-numero" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->numero : old('numero') }}"
                                        placeholder="{{ __('Número') }}"  />
                                    @if ($errors->has('numero'))
                                        <span id="numero-error" class="error text-danger"
                                            for="input-numero">{{ $errors->first('numero') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Complemento --}}
                            <div class="col-5">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('complemento') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Complemento') }}</label>
                                    <input class="form-control{{ $errors->has('complemento') ? ' is-invalid' : '' }}"
                                        name="complemento" id="input-complemento" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->complemento : old('complemento') }}"
                                        placeholder="{{ __('Complemento') }}"  />
                                    @if ($errors->has('complemento'))
                                        <span id="complemento-error" class="error text-danger"
                                            for="input-complemento">{{ $errors->first('complemento') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Bairro --}}
                            <div class="col-5">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('bairro') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Bairro') }}</label>
                                    <input class="form-control{{ $errors->has('bairro') ? ' is-invalid' : '' }}"
                                        name="bairro" id="input-bairro" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->bairro : old('bairro') }}"
                                        placeholder="{{ __('Bairro') }}"  />
                                    @if ($errors->has('bairro'))
                                        <span id="bairro-error" class="error text-danger"
                                            for="input-bairro">{{ $errors->first('bairro') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Cidade --}}
                            <div class="col-5">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('cidade') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Cidade') }}</label>
                                    <input class="form-control{{ $errors->has('cidade') ? ' is-invalid' : '' }}"
                                        name="cidade" id="input-cidade" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->cidade : old('cidade') }}"
                                        placeholder="{{ __('Cidade') }}"  />
                                    @if ($errors->has('cidade'))
                                        <span id="cidade-error" class="error text-danger"
                                            for="input-cidade">{{ $errors->first('cidade') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Estado --}}
                            <div class="col-2">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('estado') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Estado') }}</label>
                                    <input class="form-control{{ $errors->has('estado') ? ' is-invalid' : '' }}"
                                        name="estado" id="input-estado" type="text"
                                        value="{{ isset($pessoa) ? $pessoa->estado : old('estado') }}"
                                        placeholder="{{ __('Estado') }}"  />
                                    @if ($errors->has('estado'))
                                        <span id="estado-error" class="error text-danger"
                                            for="input-estado">{{ $errors->first('estado') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        @include('partials.status', ['model' => $pessoa ?? null])
    </div>
    @if(isset($pessoa))
    <div class="col-md-6">
        @include('partials.upload', ['model' => $pessoa])
    </div>
    @endif
</div>
<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button type="submit" class="btn btn-success">{{ __((isset($pessoa) ? 'Atualizar' : 'Adicionar').'') }}</button>
        <a href="{{ route('admin.pessoas.index',['tipo' => $tipo]) }}"
                class="btn btn-light">{{ __('Voltar para a lista') }}</a>
    </div>
</div>

@push('js')
    @include('partials.upload-js')
@endpush