@php
    use Carbon\Carbon;
    // No seu provider de serviço ou em um bootstrapping do Laravel
    Carbon::setLocale('pt_BR');
@endphp
@push('css')
    {{-- Select2 --}}
    <link rel="stylesheet" href="{{ asset('assets/css/select2.min.css') }}">
@endpush
<meta name="csrf-token" content="{{ csrf_token() }}">
<?php
 $opt = '';
if(isset($produtoServico)){
    foreach($produtoServico as $prod)
    {   
            $opt .='<option value="'.$prod->idprodserv.'" data-unidade="'.$prod->unidade.'" data-valorvenda="'.$prod->valorvenda.'" data-qtdmax="'.$estoqueAtualPorProduto[$prod->idprodserv].'">'.$prod->prodserv.'</option>"';
    }
} 

?>
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Vendas</h5>
        </div>
    </div>
    <div class="card-body ">
    {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
            @endif

        <div class="row">
            @if (isset($venda))
            <div class="col-md-9 col-lg-9"> 
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$venda->idnf;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{$bg_status}}"><?=$venda->status;?></span>
            </div>
        @endif
        </div>
    </div>
</div>

<div class="card mb-4">
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
            </div>
            <div class="col-md-12 col-lg-12">
                <div class="row">
                    {{-- Empresa --}}
                    <div class="col-8">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Empresa</label>
                            <select class="form-control" name="idempresa">
                            <option value="" disabled="disabled">- Selecionar -</option>
                            @foreach($empresas as $empresa)
                                <option value="{{ $empresa->idempresa }}" {{ ((isset($venda) && $empresa->idempresa == $venda->empresa->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                            @endforeach
                            </select>
                        </div>
                    </div>
                    {{-- Tipo --}}
                        <input type="hidden" name="tipo" value="C" />
                    {{-- Saída --}}
                        <input type="hidden" name="saida" value="V" />

                    {{-- Data entrada --}}
                    <div class="col-4">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('dataentrada') ? ' is-invalid' : '' }}">
                            <label>{{ __('Data entrada') }}</label>
                            <input class="form-control {{ $errors->has('dataentrada') ? ' is-invalid' : '' }}"
                                name="dataentrada" id="input-dataentrada" type="date"
                                value="{{ isset($venda) ? $venda->dataentrada : date('Y-m-d')  }}"
                                placeholder="{{ __('Data entrada') }}" />
                            @if ($errors->has('dataentrada'))
                                <span id="dataentrada-error" class="error text-danger"
                                    for="input-dataentrada">{{ $errors->first('dataentrada') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Pessoa --}}
                    <div class="col-8">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Cliente/Colaborador</label>
                            <select class="form-control" name="idpessoa">
                                <option value="" disabled="disabled">- Selecionar -</option>
                                @foreach($pessoas as $pessoa)
                                    <option value="{{ $pessoa->idpessoa }}" {{ ((isset($venda) && $pessoa->idpessoa == $venda->idpessoa) || (old('idpessoa') == $pessoa->idpessoa)) ? 'selected' : '' }}>{{$pessoa->nome}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    {{-- Tipo de Produto e Serviço --}}
                    <div class="col-4">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Tipo</label>
                            <select class="form-control" name="idprodservtipo" required="true" aria-required="true" onchange="ApresentaVeiculo(this)"
                            @if (isset($venda))
                                disabled="disabled" readonly
                            @endif>
                                <option value="" disabled="disabled">- Selecionar -</option>
                                @foreach($tiposProdutoServico as $tipoProdutoServico)
                                    <option value="{{ $tipoProdutoServico->idprodservtipo }}" {{ ((isset($venda) && $tipoProdutoServico->idprodservtipo == $venda->idprodservtipo) || (old('idprodservtipo') == $tipoProdutoServico->idprodservtipo)) ? 'selected' : '' }}>{{$tipoProdutoServico->prodservtipo}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    @if ((isset($venda) && $tipoProdutoServico->idprodservtipo == 2) || !isset($venda))
                    {{-- Veículo --}}
                    <div class="col-8 veiculo">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Veículo</label>
                            <select class="form-control" name="idveiculo" id="input-idveiculo">
                                <option value="" disabled="disabled">- Selecionar -</option>
                                @foreach($veiculos as $veiculo)
                                    <option value="{{ $veiculo->idveiculo }}" {{ ((isset($venda) && $venda->idveiculo == $veiculo->idveiculo) || (old('idveiculo') == $veiculo->idveiculo)) ? 'selected' : '' }}>{{$veiculo->placa}} - {{$veiculo->marca}} - {{$veiculo->modelo}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    {{-- KM --}}
                    <div class="col-4 veiculo">
                        <div class="input-group input-group-static my-3 {{ $errors->has('km') ? ' is-invalid' : '' }}">
                            <label>{{ __('KM') }}</label>
                            <input class="form-control {{ $errors->has('km') ? ' is-invalid' : '' }}"
                            name="km" id="input-km" type="number" required="true" aria-required="true"
                            value="{{ isset($venda) ? $venda->km : old('km') }}" placeholder="{{ __('KM Atual') }}"/>
                            @if ($errors->has('km'))
                                <span id="km-error" class="error text-danger"
                                    for="input-km">{{ $errors->first('km') }}</span>
                            @endif
                        </div>
                    </div>
                    @endif
                    {{-- Data de Inicio --}}
                    <div class="col-4 d-none">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('datainicio') ? ' is-invalid' : '' }}">
                            <label>{{ __('Data de Inicio') }}</label>
                            <input class="form-control {{ $errors->has('datainicio') ? ' is-invalid' : '' }}"
                                name="datainicio" id="input-datainicio" type="date"
                                value="{{ isset($venda) ? $venda->datainicio : old('datainicio') }}"
                                placeholder="{{ __('Data de Inicio') }}" />
                            @if ($errors->has('datainicio'))
                                <span id="datainicio-error" class="error text-danger"
                                    for="input-datainicio">{{ $errors->first('datainicio') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Data Final --}}
                    <div class="col-4 d-none">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('datafim') ? ' is-invalid' : '' }}">
                            <label>{{ __('Data Final') }}</label>
                            <input class="form-control {{ $errors->has('datafim') ? ' is-invalid' : '' }}"
                                name="datafim" id="input-datafim" type="date"
                                value="{{ isset($venda) ? $venda->datafim : old('datafim') }}"
                                placeholder="{{ __('Data Final') }}"  />
                            @if ($errors->has('datafim'))
                                <span id="datafim-error" class="error text-danger"
                                    for="input-datafim">{{ $errors->first('datafim') }}</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@if(isset($venda) and isset($venda->idpessoa))
<div class="row">
    <div class="col-md-8">
        @include('partials.endereco', ['readonly' => true, 'idpessoa' => $venda->idpessoa])
    </div>
    <div class="col-md-4">
        @include('partials.contato', ['readonly' => true, 'idpessoa' => $venda->idpessoa])
    </div>
</div>
@endif
<div class="row">
    <div class="col-md-8">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados de Pagamento</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                        {{-- Forma Pagamento --}}
                            <div class="col-4">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Forma de Pagamento</label>
                                    <select class="form-control" name="idformapagamento">
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                        @foreach($formaPagamento as $pagamento)
                                            <option value="{{ $pagamento->idformapagamento }}" {{ ((isset($venda) && $pagamento->idformapagamento == $venda->idformapagamento) || (old('idformapagamento') == $pagamento->idformapagamento)) ? 'selected' : '' }}>{{$pagamento->formapagamento}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            {{-- Quantidade de parcelas --}}
                            <div class="col-4">
                                <div class="input-group input-group-static my-3 {{ $errors->has('qtdparcela') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Quantidade de parcelas') }}</label>
                                    <input class="form-control {{ $errors->has('qtdparcela') ? ' is-invalid' : '' }}"
                                    name="qtdparcela" id="input-qtdparcela" type="number" required="true" aria-required="true"
                                    value="{{ isset($venda) ? $venda->qtdparcela : old('qtdparcela') }}" placeholder="{{ __('Quantidade de Parcelas') }}"/>
                                    @if ($errors->has('qtdparcela'))
                                        <span id="qtdparcela-error" class="error text-danger"
                                            for="input-qtdparcela">{{ $errors->first('qtdparcela') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Data Vencimento --}}
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('datavencimento') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Data Vencimento') }}</label>
                                    <input class="form-control {{ $errors->has('datavencimento') ? ' is-invalid' : '' }}"
                                        name="datavencimento" id="input-datavencimento" type="date"
                                        value="{{ isset($venda) ? $venda->datavencimento : old('datavencimento') }}"
                                        placeholder="{{ __('Data emissão') }}" required="true" aria-required="true" />
                                    @if ($errors->has('datavencimento'))
                                        <span id="datavencimento-error" class="error text-danger"
                                            for="input-datavencimento">{{ $errors->first('datavencimento') }}</span>
                                    @endif
                                </div>  
                            </div>
                            {{-- Observação --}}
                            <div class="col-12">
                                <div class="input-group input-group-static my-3 {{ $errors->has('observacao') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Observação') }}</label>
                                    <input class="form-control{{ $errors->has('observacao') ? ' is-invalid' : '' }}"
                                    name="observacao" id="input-observacao" type="text"
                                    value="{{ isset($venda) ? $venda->observacao : old('observacao') }}" placeholder="{{ __('Observação') }}"/>
                                    @if ($errors->has('observacao'))
                                        <span id="observacao-error" class="error text-danger"
                                            for="input-observacao">{{ $errors->first('observacao') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados da NF</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            {{-- Data emissão --}}
                            <div class="col-12">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('dataemissao') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Data emissão') }}</label>
                                    <input class="form-control {{ $errors->has('dataemissao') ? ' is-invalid' : '' }}"
                                        name="dataemissao" id="input-dataemissao" type="date"
                                        value="{{ isset($venda) ? $venda->dataemissao : old('dataemissao') }}"
                                        placeholder="{{ __('Data emissão') }}" />
                                    @if ($errors->has('dataemissao'))
                                        <span id="dataemissao-error" class="error text-danger"
                                            for="input-dataemissao">{{ $errors->first('dataemissao') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- NFe --}}
                            <div class="col-12">
                                <div
                                    class="input-group input-group-static my-3 {{ $errors->has('nfe') ? ' is-invalid' : '' }}">
                                    <label>{{ __('NFe') }}</label>
                                    <input class="form-control{{ $errors->has('nfe') ? ' is-invalid' : '' }}"
                                        name="nfe" id="input-nfe" type="text"
                                        value="{{ isset($venda) ? $venda->nfe : old('nfe') }}"
                                        placeholder="{{ __('NFe') }}"  />
                                    @if ($errors->has('nfe'))
                                        <span id="nfe-error" class="error text-danger"
                                            for="input-nfe">{{ $errors->first('nfe') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>  
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card mb-4">
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <h4 class="mb-3 bg-light">Itens de Venda(s)
                @if(isset($nfItem))
                    <a style="float:right" class="insertRecord btn btn-info btn-sm" data-id="{{ isset($venda) ? $venda->idnf : old('idnf') }}" >+ adicionar item</a>
                @endif</h4>
            </div>
            <div class="col-md-12 col-lg-12">
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class='table table-hover table-striped table-bordered table-sm' id="tab_logic">
                                <thead>
                                    <tr class="info" style="font-size:14px;">
                                        <th class="th-sm">AÇÃO</th>
                                        <th class="w-75">PRODUTO</th>
                                        <th class="th-sm"></th>
                                        <th class="th-sm">QTD</th>
                                        <th class="th-sm">UN</th>
                                        <th class="th-sm">VALOR UN.</th>
                                        <th class="th-sm">VALOR TOTAL</th>
                                        
                                    </tr>
                                </thead>
                                <tbody class="resultbody">
                                    @if(isset($nfItem))
                                        @foreach ($nfItem as $itens) 
                                        <tr id="{{ isset($itens) ? $itens->idnfitem : old('idnfitem') }}">
                                            <input class='form-control input-sm'style='width:100%;' type="hidden" name="idnfitem[]" value="{{ isset($itens) ? $itens->idnfitem : old('idnfitem') }}">
                                            <input class='form-control input-sm'style='width:100%;' type="hidden" name="idnf[]" value="{{ isset($itens) ? $itens->idnf : old('idnf') }}">
                                            <td class="custom-tbl" style="text-align: center;">
                                                <a class="deleteRecord btn-sm text-danger material-icons text-sm me-2" data-id="{{ $itens->idnfitem }}" style="cursor: pointer;" >delete</a>
                                            </td>
                                           
                                            <td>
                                                <select class="form-control input-sm" name="idprodserv[]" onchange="getSelectedValue(this)">
                                                    <option value="">- Selecionar -</option>
                                                    @foreach($produtoServico as $prod)
                                                        <option value="{{ $prod->idprodserv }}" 
                                                                data-unidade="{{ $prod->unidade }}"
                                                                data-valorvenda="{{ $prod->valorvenda }}"
                                                                data-qtdmax="{{ $estoqueAtualPorProduto[$prod->idprodserv] }}"
                                                                {{ ((isset($itens) && $prod->idprodserv == $itens->idprodserv) || (old('idprodserv') == $prod->idprodserv)) ? 'selected' : '' }}>{{$prod->prodserv}}</option>
                                                    @endforeach
                                                </select>
                                            </td>
                                            <td class="custom-tbl">         
                                                @if(isset($itens->evento_idevento))
                                                    <a target="_blank" href="/admin/eventos/{{$itens->evento_idevento}}/edit"><span class="badge badge-sm bg-gradient-dark">{{ Carbon::parse($itens->evento_data)->formatLocalized('%a %d/%m') }} {{ Carbon::parse($itens->evento_hora)->format('H:i') }} - {{$itens->eventotipo}}  - {{$itens->evento}}</span></a> 
                                                @endif  
                                            </td>
                                            <td class="custom-tbl">
                                                <input style="text-align: right;" step="0.01" class='form-control input-sm'style='width:100%;' type="text" name="qtd[]" name="qtd[]" value="{{ isset($itens) ? number_format($itens->qtd, 2, ',','') : old('qtd') }}" onblur="updateValorItem(this)" oninput="formatarEntradaNumerica(this);updateValorItem(this)" >
                                            </td>
                                            <td class="custom-tbl">
                                                <input class='form-control input-sm'style='width:100%;' type="text" name="un[]" value="{{ isset($itens) ? $itens->un : old('un') }}">
                                            </td>
                                            <td class="custom-tbl">
                                                <input style="text-align: right;" step="0.01" class='form-control input-sm'style='width:100%;' type="text" name="valorun[]" value="{{ isset($itens) ? number_format($itens->valorun, 2, ',','') : old('valorun') }}" onblur="updateValorItem(this)" oninput="formatarEntradaNumerica(this);updateValorItem(this)">
                                            </td>
                                            <td class="custom-tbl">
                                                <input style="text-align: right;" step="0.01" class='form-control input-sm'style='width:100%;' type="number" name="valoritem[]" value="{{ isset($itens) ? $itens->valoritem : old('valoritem') }}" readonly>
                                            </td>
                                        
                                        </tr>
                                        @endforeach 
                                    @endif               
                                </tbody>
                               
                                <tfoot>
                                    <tr class='info'>
                                        <td style='width:65%;text-align:right;padding:4px;font-size:14px;' colspan='6'>VALOR DOS ITENS:</td>
                                        <td style='padding:0px;font-size:14px;'>
                                            <input style="text-align:right;" class="form-control  input-sm {{ $errors->has('valornf') ? ' is-invalid' : '' }}"
                                                name="valornf" id="input-valornf" type="number" step="0.01"
                                                value="{{ isset($venda) ? $venda->valornf : old('valornf') }}" placeholder="{{ __('Valor da NF') }}" readonly/>
                                                @if ($errors->has('valornf'))
                                                    <span id="valornf-error" class="error text-danger"
                                                        for="input-valornf">{{ $errors->first('valornf') }}</span>
                                                @endif
                                                
                                        </td>
                                    </tr>
                                    <tr class='info'>
                                        <td style='width:65%;text-align:right;padding:4px;font-size:14px;' colspan='6'>VALOR DO DESCONTO (-):</td>
                                        <td style='padding:0px;font-size:14px;'>

                                        <input style="text-align:right;" class="form-control  input-sm {{ $errors->has('descontonf') ? ' is-invalid' : '' }}"
                                                name="descontonf" id="input-descontonf" type="text" step="0.01"  placeholder="{{ __('Valor do Desconto') }}"
                                                value="{{ isset($venda) ? number_format($venda->descontonf, 2, ',','') : old('descontonf') }}" onblur="updateValorNf()" oninput="formatarEntradaNumerica(this);updateValorNf()"/>
                                                @if ($errors->has('descontonf'))
                                                    <span id="descontonf-error" class="error text-danger"
                                                        for="input-descontonf">{{ $errors->first('descontonf') }}</span>
                                                @endif

                                        </td>
                                    </tr>
                                    <tr class='info'>
                                        <td style='width:65%;text-align:right;padding:4px;font-size:14px;' colspan='6'>VALOR TOTAL:</td>
                                        <td style='padding:0px;font-size:14px;'>

                                        <input style="text-align:right;" class="form-control  input-sm {{ $errors->has('totalnf') ? ' is-invalid' : '' }}"
                                                name="totalnf" id="input-totalnf" type="number" step="0.01"
                                                value="{{ isset($venda) ? $venda->totalnf : old('totalnf') }}" placeholder="{{ __('Valor Total da NF') }}" readonly/>
                                                @if ($errors->has('totalnf'))
                                                    <span id="totalnf-error" class="error text-danger"
                                                        for="input-totalnf">{{ $errors->first('totalnf') }}</span>
                                                @endif

                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@if(isset($nfParcela))
<div class="card mb-4">
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 col-lg-12">
				<h4 class="mb-3 bg-light">Parcela(s) 
                </h4>
            </div>
            <div class="col-md-12 col-lg-12">
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class='table table-hover table-striped table-bordered table-sm' id="tab_logic">
                            <thead>
                                <tr>
                                    <th
                                        class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        ID
                                    </th>
                                    <th
                                        class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        NF
                                    </th>
                                    <th
                                        class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Parcela
                                    </th>
                                    <th
                                        class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Total
                                    </th>
                                    <th
                                        class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        Status
                                    </th>
                                    <th
                                        class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                        VENCIMENTO
                                    </th>
                                    
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($nfParcela as $parcela)
                                    <tr>
                                        <td>
                                            <div class="d-flex px-2 py-1">
                                                <div class="d-flex flex-column justify-content-center">
                                                    <p class="mb-0 text-sm"><a href="/admin/nfparcelas/{{$parcela->idnfparcela }}/edit">{{$parcela->idnfparcela }}</a></p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex px-2 py-1">
                                                <div class="d-flex flex-column justify-content-center">
                                                    <a
                                                        href="{{ route('admin.compras.edit', $parcela->nf->idnf) }}">
                                                        <p class="mb-0 text-sm">{{ $parcela->nf->idnf }}</p>
                                                    </a>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex px-2 py-1">
                                                <div class="d-flex flex-column justify-content-center">
                                                    <p class="mb-0 text-sm">{{ $parcela->parcela }} /
                                                        {{ $parcela->nf->qtdparcela }}</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex px-2 py-1">
                                                <div class="d-flex flex-column justify-content-center">
                                                    <p class="mb-0 text-sm">R$
                                                        {{ number_format($parcela->valor, 2, ',', '.') }}
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex px-2 py-1">
                                                <div class="d-flex flex-column justify-content-center">
                                                    <p class="mb-0 text-sm">{{ $parcela->status }}</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex flex-column justify-content-center">
                                                <h6 class="mb-0 text-sm">
                                                    {{  date('d/m/Y', strtotime($parcela->datavencimento)) }}</h6>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endif
<div class="row">
    <div class="col-md-6">
        @include('partials.status', ['model' => $venda ?? null])
    </div>
    @if(isset($venda))
    <div class="col-md-6">
        @include('partials.upload', ['model' => $venda])
    </div>
    @endif

</div>

<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($venda) ? 'Atualizar' : 'Adicionar').' Venda') }}</button>
        <a href="{{ route('admin.vendas.index') }}"
                   class="btn btn-light">{{ __('Voltar') }}</a>
        @if(isset($venda))
        <a class="btn bg-gradient-dark" href="{{route('admin.vendas.create')}}"><i
                    class="material-icons text-sm">add</i>&nbsp;&nbsp;Nova Venda</a>
        @endif
    </div>
</div>
@push('js')
    {{-- Select2 --}}
    <script src="{{ asset('assets/js/plugins/select2.min.js') }}"></script>
    <script>

        

        $('.select2').select2();
    
            $(document).on("click", ".deleteRecord", function(){
                var id = $(this).data("id");
                var token = $("meta[name='csrf-token']").attr("content");
                $.ajax({
                    url: "../../nfitem/"+id,
                    type: 'DELETE',
                    data: {
                        "id": id,
                        "_token": token,
                    },
                    success: function (){
                        console.log("it Works");
                        var row = $('#'+id).remove();
                        //row.style.display = 'none';
                        updateValorNf();
                    }
                    });
                });

            

            function montaHtml(idnfitem, idnf){
                var trHTML = '<tr id="'+idnfitem+'">' +
                                    '<input class="form-control input-sm" style="width:100%;" type="hidden" name="idnfitem[]" value="'+idnfitem+'" onfocus="focused(this)" onfocusout="defocused(this)">' +
                                    '<input class="form-control input-sm" style="width:100%;" type="hidden" name="idnf[]" value="'+idnf+'" onfocus="focused(this)" onfocusout="defocused(this)">' +
                                '<td class="custom-tbl" style="text-align: center;">' +
                                    '<a class="deleteRecord btn-sm text-danger material-icons text-sm me-2" data-id="'+idnfitem+'" style="cursor: pointer;">delete</a>' +
                                '</td>' +
                                '<td class="custom-tbl">' +
                                    '<select class="form-control input-sm" name="idprodserv[]" onchange="getSelectedValue(this)">' +
                                        '<option value="">- Selecionar -</option><?=$opt;?>'+
                                    '</select>' +
                                '</td>' +
                                '<td class="custom-tbl"></td>'+
                                '<td class="custom-tbl">' +
                                    '<input style="text-align: right;" class="form-control input-sm" style="width:100%;" type="text" name="qtd[]" step="0.01" value="" onfocus="focused(this)" onfocusout="defocused(this)" onblur="updateValorItem(this)" oninput="formatarEntradaNumerica(this);updateValorItem(this)" >' +
                                '</td>' +
                                '<td class="custom-tbl">' +
                                    '<input class="form-control input-sm" style="width:100%;" type="text" name="un[]" value="" onfocus="focused(this)" onfocusout="defocused(this)">' +
                                '</td>' +
                                '<td class="custom-tbl">' +
                                    '<input style="text-align: right;" class="form-control input-sm" style="width:100%;" type="text" name="valorun[]" step="0.01" value="" onfocus="focused(this)" onfocusout="defocused(this)" onblur="updateValorItem(this)" oninput="formatarEntradaNumerica(this);updateValorItem(this)" >' +
                                '</td>' +
                                '<td class="custom-tbl">' +
                                    '<input style="text-align: right;" class="form-control input-sm" style="width:100%;" type="number" name="valoritem[]"  step="0.01" value="" onfocus="focused(this)" onfocusout="defocused(this)">' +
                                '</td>' +
                            '</tr>';
                return trHTML;
            }
                
            $(".insertRecord").click(function(){

                

                var id = $(this).data("id");
                var token = $("meta[name='csrf-token']").attr("content");
                $.ajax({
                    url: "../../nfitemadd/"+id,
                    type: 'POST',
                    data: {
                        "id": id,
                        "_token": token,
                    },
                    success: function (response){
                        console.log("it Works");
                        var idNfItem = response.success;
                        var tr = montaHtml(idNfItem);
                        $('#tab_logic').append(tr);
                        
                    }
                    });
                });
    
    </script> 
    <script>
    function getSelectedValue(select) {
        var selectedOption = select.options[select.selectedIndex];
        var prodData = selectedOption.dataset;
        var row = select.closest('tr');
        // Preencha os outros campos com os dados obtidos
        row.querySelector("input[name='un[]']").value = prodData.unidade;
        row.querySelector("input[name='valorun[]']").value = prodData.valorvenda;
    //    row.querySelector("input[name='qtd[]']").max = prodData.qtdmax;
        row.querySelector("input[name='qtd[]']").focus();
        row.querySelector("input[name='qtd[]']").blur();
        updateValorNf();
  
    }

    function updateValorItem(element) {
        debugger;
        var row = element.closest('tr'); // Encontra o elemento pai <tr>
        var qtd = converterParaNumero(row.querySelector("input[name='qtd[]']").value);
        var valorUn = converterParaNumero(row.querySelector("input[name='valorun[]']").value);
        if (!isNaN(parseFloat(valorUn)) && valorUn !== "" && valorUn !== undefined) {
        // O valor é válido e não é NaN
            valorUn = (valorUn);
            //alert(0);
        } else {
        // O valor é inválido ou NaN
            valorUn.value = 0;
           // alert(1);
        }

        if (!isNaN(parseFloat(qtd)) && qtd.value !== "" && qtd !== undefined) {
        // O valor é válido e não é NaN
            qtd = (qtd);
        } else {
        // O valor é inválido ou NaN
            qtd = 0;
        }
        var valorItem = qtd * valorUn;
        var valorItemInput = row.querySelector("input[name='valoritem[]']");
        valorItemInput.value = valorItem.toFixed(2);
       // valorItemInput.value = valorItemInput.value.replace('.', ',');
        updateValorNf();
    }

    function updateValorNf() { 
        //debugger;
        var valorItemInputs = document.querySelectorAll("input[name='valoritem[]']");
        var valornf = 0;

        // Itera sobre os campos e soma os valores
        for (var i = 0; i < valorItemInputs.length; i++) {

            valorItemInputs[i].value = valorItemInputs[i].value.replace(',', '.'); 
            var valorItem = parseFloat(valorItemInputs[i].value);
            if (!isNaN(valorItem)) {
                valornf += valorItem;
            }
        }

        // Atualiza o campo de valor total
        var valornfInput = document.querySelector("input[name='valornf']");
        if (valornfInput) {
            valornfInput.value = valornf.toFixed(2);
        }

        //Busca o valor do campo Desconto
        var descontonfInput = document.querySelector("input[name='descontonf']");

        // Atualiza o campo de valor total
        var totalnfInput = document.querySelector("input[name='totalnf']");
       
        var valornf = parseFloat(valornfInput.value); // Supondo que valornfInput é o valor original
        var desconto = parseFloat(descontonfInput.value); // Converte o valor do desconto para um número
        if (desconto) {
            var total = valornf - desconto; // Calcula o total
        }else{
            var total = valornf;
        }   
        totalnfInput.value = total.toFixed(2); // Formata o número com dois dígitos decimais e define o valor do input
    
    }

    function atualizarTodosItens() {
        // Seleciona todas as linhas da tabela no corpo da tabela com classe 'resultbody'
        var linhas = document.querySelectorAll("#tab_logic tbody.resultbody tr");

        // Itera por cada linha
        linhas.forEach(function(row) {
            // Encontra o primeiro input de quantidade na linha para usar como argumento para a função updateValorItem
            var inputQtd = row.querySelector("input[name='qtd[]']");

            // Chama a função updateValorItem passando o input encontrado como argumento
            if (inputQtd) {
                updateValorItem(inputQtd);
            }
        });
    }


    // Chama a função ApresentaDados quando a página é carregada
    document.addEventListener('DOMContentLoaded', function() {
        atualizarTodosItens();
    });
// Chamar a função atualizarTodosItens quando necessário

</script>
<script>
function ApresentaVeiculo(selectElement) {
    const inputKm = document.getElementById('input-km');
    const inputVeiculo = document.getElementById('input-idveiculo');
    if (selectElement.value === '2') {
        if (inputKm) {
            $('.veiculo').show();
            inputKm.required = true;
            inputKm.setAttribute('aria-required', 'true');
        }
        if (inputVeiculo) {
            inputVeiculo.required = true;
            inputVeiculo.setAttribute('aria-required', 'true');
        }
    } else {
        if (inputKm) {
            $('.veiculo').hide();
            inputKm.required = false;
            inputKm.removeAttribute('aria-required');
        }
        if (inputVeiculo) {
            inputVeiculo.required = false;
            inputVeiculo.removeAttribute('aria-required');
        }
    }
}
const inputKm = document.getElementById('input-km');
const inputVeiculo = document.getElementById('input-idveiculo');
<?
if ((isset($venda) && $venda->idprodservtipo != 2) || !isset($venda)){
?>
    $('.veiculo').hide();
<?
}
?>
if (inputKm) {
    inputKm.required = false;
    inputKm.removeAttribute('aria-required');
}
if (inputVeiculo) {
    inputVeiculo.required = false;
    inputVeiculo.removeAttribute('aria-required');
}
</script>

<script>

    function formatarEntradaNumerica(el) {
        // Primeiro, substitui todos os pontos por vírgulas
        let valor = el.value.replace(/\./g, ',');

        // Remove caracteres que não são dígitos ou vírgula
        valor = valor.replace(/[^0-9,]/g, '');

        // Permite apenas uma vírgula
        let partes = valor.split(',');
        if (partes.length > 2) {
            valor = partes[0] + ',' + partes.slice(1).join('');
        }

        el.value = valor;
    }

    function converterParaNumero(valor) {
        // Verifica se o valor é não nulo e não vazio
        if (valor) {
            // Converte vírgulas em pontos
            var valorConvertido = valor.replace(',', '.');

            // Converte para float e verifica se é NaN. Se for NaN, retorna 0
            var numero = parseFloat(valorConvertido);
            return isNaN(numero) ? 0 : numero;
        }
        return 0;
    }


</script>
    @include('partials.upload-js')
@endpush

