@props(['activePage'])
<style>
    .navbar-vertical.navbar-expand-xs .navbar-nav .nav-link {
        padding-top: 0.10rem;
        padding-bottom: 0.10rem;
    }
    .icon-container {
        width: 24px;
        height: 24px;
    }

    .navbar-vertical.navbar-expand-xs .navbar-collapse{
        overflow-x: hidden;
    }
    .navbar-vertical.navbar-expand-xs{
        overflow:hidden;
    }
</style>
<aside
    class="sidenav navbar navbar-vertical navbar-expand-xs border-0 border-radius-xl my-3 fixed-start ms-3   bg-gradient-dark"
    id="sidenav-main">
    <div class="sidenav-header visually-hidden">
        <i class="fas fa-times p-3 cursor-pointer text-white opacity-5 position-absolute end-0 top-0 d-none d-xl-none"
            aria-hidden="true" id="iconSidenav"></i>
        <a class="navbar-brand m-0 d-flex text-wrap align-items-center" href=" {{ route('dashboard') }} ">
            <img src="{{ asset('assets') }}/img/logo-ct.png" class="navbar-brand-img h-100" alt="main_logo">
            <span class="ms-2 font-weight-bold text-white">Empresa</span>
        </a>
    </div>
    <hr class="horizontal light mt-0 mb-2 visually-hidden">
    <div class="collapse navbar-collapse  w-auto  max-height-vh-100" id="sidenav-collapse-main">
        <ul class="navbar-nav">
        <li class="nav-item mt-2">
                <h6 class="ms-2 text-uppercase text-xs text-white font-weight-bolder opacity-8">Dashboard</h6>
            </li>
            {{-- Compras --}}
            <li class="nav-item">
                <a class="nav-link text-white {{ $activePage == 'dashboard.financeiro' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('dashboard.financeiro') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg fa-chart-line ps-2 pe-2 text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Financeiro</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link text-white {{ $activePage == 'dashboard.produto' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('dashboard.produto') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg  fa-chart-bar  ps-2 pe-2 text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Produto</span>
                </a>
            </li>
            <li class="nav-item mt-2">
                <h6 class="ms-2 text-uppercase text-xs text-white font-weight-bolder opacity-8">Finanças</h6>
            </li>
            {{-- Compras --}}
            <li class="nav-item">
                <a class="nav-link text-white {{ $activePage == 'compras' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.compras.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg fa-shopping-cart ps-2 pe-2 text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Compras</span>
                </a>
            </li>
            {{-- Pedidos --}}
            <li class="nav-item">
                <a class="nav-link text-white {{ $activePage == 'pedidos' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.pedidos.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg fa-dolly ps-2 pe-2 text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Pedidos</span>
                </a>
            </li>
            {{-- Vendas --}}
            <li class="nav-item">
                <a class="nav-link text-white {{ $activePage == 'vendas' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.vendas.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg fa-money-bill ps-2 pe-2 text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Vendas</span>
                </a>
            </li>
            {{-- Parcelas --}}
            <li class="nav-item">
                <a class="nav-link text-white {{ $activePage == 'nfparcelas' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.nfparcelas.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg fa-dollar-sign ps-2 pe-2 text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1"> Parcelas</span>
                </a>
            </li>
            <li class="nav-item mt-2">
                <h6 class="ms-2 text-uppercase text-xs text-white font-weight-bolder opacity-8">Gestão</h6>
            </li>
            {{-- Empresas --}}
            <li class="nav-item">
                <a class="nav-link text-white {{ $activePage == 'empresas' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.empresas.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg fa-building ps-2 pe-2 text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Empresas</span>
                </a>
            </li>
            {{-- Veiculos --}}
            <li class="nav-item">
                <a class="nav-link text-white {{ $activePage == 'veiculos' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.veiculos.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg fa-truck ps-2 pe-2 text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Frota</span>
                </a>
            </li>
            {{-- Contratos --}}
            <li class="nav-item">
                <a class="nav-link text-white {{ $activePage == 'contratos' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.contratos.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg fa-file-contract ps-2 pe-2 text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Contratos</span>
                </a>
            </li>
            <li class="nav-item mt-2">
                <h6 class="ms-2 text-uppercase text-xs text-white font-weight-bolder opacity-8">Config</h6>
            </li>
            {{-- Tipo Produto / Serviço --}}
            <li class="nav-item">
                <a class="nav-link text-white {{ $activePage == 'tipo-produto-servico' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.tipo-produto-servico.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg fa-boxes ps-2 pe-2 text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Tipo Produto / Serviço</span>
                </a>
            </li>
            {{-- Produto / Serviço --}}
            <li class="nav-item">
                <a class="nav-link text-white {{ $activePage == 'produto-servico' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.produto-servico.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg fa-box-open ps-2 pe-2 text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Produto / Serviço</span>
                </a>
            </li>
            <li class="nav-item ">
                <a class="nav-link text-white {{ $activePage == 'grupoitens' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.grupoitens.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg ps-2 pe-2 fa-key text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Grupo Itens</span>
                </a>
            </li>
            <? if (auth()->user()->idtenant == 1) { ?>
            <li class="nav-item ">
                <a class="nav-link text-white {{ $activePage == 'itens' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.itens.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg ps-2 pe-2 fa-key text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Itens</span>
                </a>
            </li>
            <? } ?>
            {{-- Forma de pagamento --}}
            <li class="nav-item">
                <a class="nav-link text-white {{ $activePage == 'forma-pagamento' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.forma-pagamento.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg fa-credit-card ps-2 pe-2 text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Forma de pagamento</span>
                </a>
            </li>
            {{-- Agencias --}}
            <li class="nav-item visually-hidden">
                <a class="nav-link text-white {{ $activePage == 'agencias' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.agencias.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg material-icons ps-2 pe-2 text-center">lock</i>
                    </div>
                    <span class="nav-link-text ms-1">Agências</span>
                </a>
            </li>
            <li class="nav-item mt-2">
                <h6 class="ms-2 text-uppercase text-xs text-white font-weight-bolder opacity-8">Pessoas</h6>
            </li>
            {{-- Fornecedores --}}
            <li class="nav-item">
                <a class="nav-link text-white {{ $activePage == 'fornecedor' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.pessoas.index', ['tipo' => 'fornecedor']) }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg fa-shipping-fast ps-2 pe-2 text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Fornecedores</span>
                </a>
            </li>
            {{-- Clientes --}}
            <li class="nav-item">
                <a class="nav-link text-white {{ $activePage == 'cliente' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.pessoas.index', ['tipo' => 'cliente']) }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg fa-users ps-2 pe-2 text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Clientes</span>
                </a>
            </li>
            {{-- Funcionários --}}
            <li class="nav-item">
                <a class="nav-link text-white {{ $activePage == 'funcionarios' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.funcionarios.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg fa-sitemap ps-2 pe-2 text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Funcionários</span>
                </a>
            </li>
            {{-- Pessoas --}}
            {{-- <li class="nav-item">
                <a class="nav-link text-white {{ $activePage == 'pessoas' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.pessoas.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg material-icons ps-2 pe-2 text-center">lock</i>
                    </div>
                    <span class="nav-link-text ms-1">Pessoas</span>
                </a>
            </li> --}}
            
            <li class="nav-item mt-2 visually-hidden">
                <h6 class="ms-2 text-uppercase text-xs text-white font-weight-bolder opacity-8">Gerenciamento</h6>
            </li>
            {{-- Perfil --}}
            <li class="nav-item visually-hidden">
                <a class="nav-link text-white {{ $activePage == 'user-profile' ? 'active bg-gradient-secundary' : '' }} "
                    href="{{ route('user-profile') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1.2rem;" class="fas fa-user-circle ps-2 pe-2 text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Acessos</span>
                </a>
            </li>
            <li class="nav-item mt-2">
                <h6 class="ms-2 text-uppercase text-xs text-white font-weight-bolder opacity-8">Acessos</h6>
            </li>
            {{-- Usuarios --}}
            <li class="nav-item ">
                <a class="nav-link text-white {{ $activePage == 'users' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.users.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg ps-2 pe-2 fa-key text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Usuários</span>
                </a>
            </li>

            <? if (auth()->user()->idtenant == 1 || auth()->user()->idtenant == 2) { ?>
            <li class="nav-item ">
                <a class="nav-link text-white {{ $activePage == 'eventos' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.eventos.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg ps-2 pe-2 fa-key text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Eventos</span>
                </a>
            </li>
            <? } ?>
            <? if (auth()->user()->idtenant == 1 || auth()->user()->idtenant == 2) { ?>
            <li class="nav-item ">
                <a class="nav-link text-white {{ $activePage == 'eventotipos' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.eventotipos.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg ps-2 pe-2 fa-key text-center"></i>
                    </div>
                    <span class="nav-link-text ms-1">Tipo Eventos</span>
                </a>
            </li>
            <? } ?>
            {{-- Permissoes --}}
            <li class="nav-item visually-hidden">
                <a class="nav-link text-white {{ $activePage == 'permission-group' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('admin.permissions.index') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i style="font-size: 1rem;" class="fas fa-lg material-icons ps-2 pe-2 text-center">lock</i>
                    </div>
                    <span class="nav-link-text ms-1">Grupos de permissões</span>
                </a>
            </li>
           
            <li class="nav-item mt-2 visually-hidden">
                <h6 class="ms-2 text-uppercase text-xs text-white font-weight-bolder opacity-8">Pages</h6>
            </li>
            <li class="nav-item visually-hidden">
                <a class="nav-link text-white {{ $activePage == 'dashboard' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('dashboard') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i class="material-icons opacity-10">dashboard</i>
                    </div>
                    <span class="nav-link-text ms-1">Dashboard</span>
                </a>
            </li>
            <li class="nav-item visually-hidden">
                <a class="nav-link text-white {{ $activePage == 'tables' ? ' active bg-gradient-secundary' : '' }} "
                    href="{{ route('tables') }}">
                    <div class="icon-container text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i class="material-icons opacity-10">table_view</i>
                    </div>
                    <span class="nav-link-text ms-1">Tables</span>
                </a>
            </li>
            <li class="nav-item visually-hidden">
                <a class="nav-link text-white {{ $activePage == 'billing' ? ' active bg-gradient-secundary' : '' }}  "
                    href="{{ route('billing') }}">
                    <div class="text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i class="material-icons opacity-10">receipt_long</i>
                    </div>
                    <span class="nav-link-text ms-1">Billing</span>
                </a>
            </li>
            <li class="nav-item visually-hidden">
                <a class="nav-link text-white {{ $activePage == 'virtual-reality' ? ' active bg-gradient-secundary' : '' }}  "
                    href="{{ route('virtual-reality') }}">
                    <div class="text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i class="material-icons opacity-10">view_in_ar</i>
                    </div>
                    <span class="nav-link-text ms-1">Virtual Reality</span>
                </a>
            </li>
            <li class="nav-item visually-hidden">
                <a class="nav-link text-white {{ $activePage == 'rtl' ? ' active bg-gradient-secundary' : '' }}  "
                    href="{{ route('rtl') }}">
                    <div class="text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i class="material-icons opacity-10">format_textdirection_r_to_l</i>
                    </div>
                    <span class="nav-link-text ms-1">RTL</span>
                </a>
            </li>
            <li class="nav-item visually-hidden">
                <a class="nav-link text-white {{ $activePage == 'notifications' ? ' active bg-gradient-secundary' : '' }}  "
                    href="{{ route('notifications') }}">
                    <div class="text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i class="material-icons opacity-10">notifications</i>
                    </div>
                    <span class="nav-link-text ms-1">Notifications</span>
                </a>
            </li>
            <li class="nav-item mt-2 visually-hidden">
                <h6 class="ms-2 text-uppercase text-xs text-white font-weight-bolder opacity-8">Account pages</h6>
            </li>
            <li class="nav-item visually-hidden">
                <a class="nav-link text-white {{ $activePage == 'profile' ? ' active bg-gradient-secundary' : '' }}  "
                    href="{{ route('profile') }}">
                    <div class="text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i class="material-icons opacity-10">person</i>
                    </div>
                    <span class="nav-link-text ms-1">Profile</span>
                </a>
            </li>
            <li class="nav-item visually-hidden">
                <a class="nav-link text-white " href="{{ route('static-sign-in') }}">
                    <div class="text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i class="material-icons opacity-10">login</i>
                    </div>
                    <span class="nav-link-text ms-1">Sign In</span>
                </a>
            </li>
            <li class="nav-item visually-hidden">
                <a class="nav-link text-white " href="{{ route('static-sign-up') }}">
                    <div class="text-white text-center me-2 d-flex align-items-center justify-content-center">
                        <i class="material-icons opacity-10">assignment</i>
                    </div>
                    <span class="nav-link-text ms-1">Sign Up</span>
                </a>
            </li>
        </ul>
    </div>
</aside>
