

<script>

        // Aqui, assumimos que você tem uma propriedade em seu componente Livewire chamada 'dadosGrafico'
        var dadosGrafico2 = @json($GraficoComprasPorMesJs);

        var ctx2 = document.getElementById("chart-compra").getContext("2d");

        new Chart(ctx2, {
            type: "bar",
            data: {
                labels: dadosGrafico2.labels, // Substituído por dados dinâmicos
                datasets: [{
                    label: "Compras",
                    tension: 0,
                    pointRadius: 5,
                    pointBackgroundColor: "rgba(229,57,53, .8)",
                    pointBorderColor: "transparent",
                    borderColor: "transparent",
                    borderWidth: 4,
                    backgroundColor: "rgba(229,57,53, .8)",
                    fill: true,
                    data: dadosGrafico2.data, // Substituído por dados dinâmicos
                    maxBarThickness: 30
                },
                {
                    label: "Meta do Mês",
                    type: 'line', // Configura a meta como uma linha
                    borderColor: "rgba(229,57,53, 1)",
                    borderWidth: 2,
                    fill: false,
                    data: dadosGrafico2.data, // Dados da meta (você precisa fornecer isso)
                }],
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false,
                    }
                },
                interaction: {
                    intersect: false,
                    mode: 'index',
                },
                scales: {
                    y: {
                        grid: {
                            drawBorder: false,
                            display: true,
                            drawOnChartArea: true,
                            drawTicks: false,
                            borderDash: [5, 5],
                            color: 'rgba(229,57,53, .2)'
                        },
                        ticks: {
                            display: true,
                            color: '#344767',
                            padding: 10,
                            font: {
                                size: 14,
                                weight: 300,
                                family: "Roboto",
                                style: 'normal',
                                lineHeight: 2
                            },
                        }
                    },
                    x: {
                        grid: {
                            drawBorder: false,
                            display: false,
                            drawOnChartArea: false,
                            drawTicks: false,
                            borderDash: [5, 5]
                        },
                        ticks: {
                            display: true,
                            color: '#344767',
                            padding: 10,
                            font: {
                                size: 14,
                                weight: 300,
                                family: "Roboto",
                                style: 'normal',
                                lineHeight: 2
                            },
                        }
                    },
                },
            },
        });
 
</script>
