@php
    $pessoa = \App\Models\Pessoa::find($idpessoa);
    if ($pessoa->tipo == 'fornecedor'){
        $titulo = 'Dados do Fornecedor';
    }else if ($pessoa->tipo == 'cliente'){
        $titulo = 'Dados do Cliente';
    }else{
        $titulo = 'Dados do Colaborador';
    }
@endphp
<div class="card mb-4">
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <h4 class="mb-3 bg-light">Contato</h4>
            </div>
            <div class="col-md-12 col-lg-12">
                <div class="row">
                {{-- Responsável --}}
                    <div class="col-md-6 col-sm-12">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('responsavel') ? ' is-invalid' : '' }}">
                            <label>{{ __('Responsável') }}</label>
                            <input class="form-control {{ $errors->has('responsavel') ? ' is-invalid' : '' }}"
                                name="responsavel" id="input-responsavel" type="text"
                                value="{{ isset($pessoa) ? $pessoa->responsavel : old('responsavel') }}"
                                placeholder="{{ __('Responsável') }}"  
                                @if(isset($readonly) && $readonly) 
                                    readonly disabled 
                                @endif />
                            @if ($errors->has('responsavel'))
                                <span id="responsavel-error" class="error text-danger"
                                    for="input-responsavel">{{ $errors->first('responsavel') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Telefone Celular --}}
                    <div class="col-md-6 col-sm-12">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('celular') ? ' is-invalid' : '' }}">
                            <label>{{ __('Telefone Celular') }}</label>
                            <input class="form-control telefone {{ $errors->has('celular') ? ' is-invalid' : '' }}"
                                name="celular" id="input-celular" type="text"
                                value="{{ isset($pessoa) ? $pessoa->celular : old('celular') }}"
                                placeholder="{{ __('Telefone Celular') }}"  
                                @if(isset($readonly) && $readonly) 
                                    readonly disabled 
                                @endif 
                                />
                            @if ($errors->has('celular'))
                                <span id="celular-error" class="error text-danger"
                                    for="input-celular">{{ $errors->first('celular') }}</span>
                            @endif
                        </div>
                    </div>
                {{-- Telefone Fixo --}}
                    <div class="col-md-6 col-sm-12">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('telefone') ? ' is-invalid' : '' }}">
                            <label>{{ __('Telefone Fixo') }}</label>
                            <input class="form-control telefone {{ $errors->has('telefone') ? ' is-invalid' : '' }}"
                                name="telefone" id="input-telefone" type="text"
                                value="{{ isset($pessoa) ? $pessoa->telefone : old('telefone') }}"
                                placeholder="{{ __('Telefone Fixo') }}"  
                                @if(isset($readonly) && $readonly) 
                                    readonly disabled 
                                @endif />
                            @if ($errors->has('telefone'))
                                <span id="telefone-error" class="error text-danger"
                                    for="input-telefone">{{ $errors->first('telefone') }}</span>
                            @endif
                        </div>
                    </div>
                   
                    {{-- Telefone Celular2 --}}
                    <div class="col-md-6 col-sm-12">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('celular2') ? ' is-invalid' : '' }}">
                            <label>{{ __('Telefone Celular2') }}</label>
                            <input class="form-control telefone {{ $errors->has('celular2') ? ' is-invalid' : '' }}"
                                name="celular2" id="input-celular2" type="text"
                                value="{{ isset($pessoa) ? $pessoa->celular2 : old('celular2') }}"
                                placeholder="{{ __('Telefone Celular2') }}" 
                                @if(isset($readonly) && $readonly) 
                                    readonly disabled 
                                @endif  />
                            @if ($errors->has('celular2'))
                                <span id="celular2-error" class="error text-danger"
                                    for="input-celular2">{{ $errors->first('celular2') }}</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>