@php
    $pessoa = \App\Models\Pessoa::find($idpessoa);
    if ($pessoa->tipo == 'fornecedor'){
        $titulo = 'do Fornecedor';
    }else if ($pessoa->tipo == 'cliente'){
        $titulo = 'do Cliente';
    }else{
        $titulo = 'do Colaborador';
    }
@endphp
<div class="card mb-4">
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <h4 class="mb-3 bg-light">Endereço {{ $titulo }}</h4>
            </div>
            <div class="col-md-12 col-lg-12">
                <div class="row">
                    {{-- Cep --}}
                    <div class="col-12">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('cep') ? ' is-invalid' : '' }}">
                            <label>{{ __('Cep') }}</label>
                            <input class="form-control cep {{ $errors->has('cep') ? ' is-invalid' : '' }}"
                                name="cep" id="input-cep" type="text"
                                value="{{ isset($pessoa) ? $pessoa->cep : old('cep') }}"
                                placeholder="{{ __('Cep') }}" 
                                @if(isset($readonly) && $readonly) 
                                    readonly disabled 
                                @else
                                    required="true" aria-required="true"
                                @endif 
                                 />
                            @if ($errors->has('cep'))
                                <span id="cep-error" class="error text-danger"
                                    for="input-cep">{{ $errors->first('cep') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Endereço --}}
                    <div class="col-5">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('endereco') ? ' is-invalid' : '' }}">
                            <label>{{ __('Endereço') }}</label>
                            <input class="form-control{{ $errors->has('endereco') ? ' is-invalid' : '' }}"
                                name="endereco" id="input-endereco" type="text"
                                value="{{ isset($pessoa) ? $pessoa->endereco : old('endereco') }}"
                                placeholder="{{ __('Endereço') }}" 
                                @if(isset($readonly) && $readonly) 
                                    readonly disabled 
                                @else
                                    required="true" aria-required="true"
                                @endif  />
                            @if ($errors->has('endereco'))
                                <span id="endereco-error" class="error text-danger"
                                    for="input-endereco">{{ $errors->first('endereco') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Número --}}
                    <div class="col-2">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('numero') ? ' is-invalid' : '' }}">
                            <label>{{ __('Número') }}</label>
                            <input class="form-control{{ $errors->has('numero') ? ' is-invalid' : '' }}"
                                name="numero" id="input-numero" type="text"
                                value="{{ isset($pessoa) ? $pessoa->numero : old('numero') }}"
                                placeholder="{{ __('Número') }}" 
                                @if(isset($readonly) && $readonly) 
                                    readonly disabled 
                                @else
                                    required="true" aria-required="true"
                                @endif  />
                            @if ($errors->has('numero'))
                                <span id="numero-error" class="error text-danger"
                                    for="input-numero">{{ $errors->first('numero') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Complemento --}}
                    <div class="col-5">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('complemento') ? ' is-invalid' : '' }}">
                            <label>{{ __('Complemento') }}</label>
                            <input class="form-control{{ $errors->has('complemento') ? ' is-invalid' : '' }}"
                                name="complemento" id="input-complemento" type="text"
                                value="{{ isset($pessoa) ? $pessoa->complemento : old('complemento') }}"
                                placeholder="{{ __('Complemento') }}" 
                                @if(isset($readonly) && $readonly) 
                                    readonly disabled    
                                @endif  />
                            @if ($errors->has('complemento'))
                                <span id="complemento-error" class="error text-danger"
                                    for="input-complemento">{{ $errors->first('complemento') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Bairro --}}
                    <div class="col-5">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('bairro') ? ' is-invalid' : '' }}">
                            <label>{{ __('Bairro') }}</label>
                            <input class="form-control{{ $errors->has('bairro') ? ' is-invalid' : '' }}"
                                name="bairro" id="input-bairro" type="text"
                                value="{{ isset($pessoa) ? $pessoa->bairro : old('bairro') }}"
                                placeholder="{{ __('Bairro') }}" 
                                @if(isset($readonly) && $readonly) 
                                    readonly disabled 
                                @else
                                    required="true" aria-required="true"
                                @endif  />
                            @if ($errors->has('bairro'))
                                <span id="bairro-error" class="error text-danger"
                                    for="input-bairro">{{ $errors->first('bairro') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Cidade --}}
                    <div class="col-5">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('cidade') ? ' is-invalid' : '' }}">
                            <label>{{ __('Cidade') }}</label>
                            <input class="form-control{{ $errors->has('cidade') ? ' is-invalid' : '' }}"
                                name="cidade" id="input-cidade" type="text"
                                value="{{ isset($pessoa) ? $pessoa->cidade : old('cidade') }}"
                                placeholder="{{ __('Cidade') }}" 
                                @if(isset($readonly) && $readonly) 
                                    readonly disabled 
                                @else
                                    required="true" aria-required="true"
                                @endif  />
                            @if ($errors->has('cidade'))
                                <span id="cidade-error" class="error text-danger"
                                    for="input-cidade">{{ $errors->first('cidade') }}</span>
                            @endif
                        </div>
                    </div>
                    {{-- Estado --}}
                    <div class="col-2">
                        <div
                            class="input-group input-group-static my-3 {{ $errors->has('estado') ? ' is-invalid' : '' }}">
                            <label>{{ __('Estado') }}</label>
                            <input class="form-control{{ $errors->has('estado') ? ' is-invalid' : '' }}"
                                name="estado" id="input-estado" type="text"
                                value="{{ isset($pessoa) ? $pessoa->estado : old('estado') }}"
                                placeholder="{{ __('Estado') }}" 
                                @if(isset($readonly) && $readonly) 
                                    readonly disabled 
                                @else
                                    required="true" aria-required="true"
                                @endif  />
                            @if ($errors->has('estado'))
                                <span id="estado-error" class="error text-danger"
                                    for="input-estado">{{ $errors->first('estado') }}</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>