<?php

use App\Http\Controllers\Admin\PessoaController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\RegisterController;
use App\Http\Controllers\SessionsController;


Route::get('/', function () {
    return redirect('sign-in');
})->middleware('guest');
Route::get('/dashboard', [DashboardController::class, 'index'])->middleware('auth')->name('dashboard');
Route::get('/dashboard/financeiro', function () { 
    return view('dashboard.financeiro');
})->middleware('auth')->name('dashboard.financeiro');

Route::get('/dashboard/produto', function () { 
    return view('dashboard.produto');
})->middleware('auth')->name('dashboard.produto');

Route::get('/dashboardfinanceiro', [DashboardController::class, 'index'])->middleware('auth')->name('dashboardfinanceiro');
Route::get('sign-up', [RegisterController::class, 'create'])->middleware('guest')->name('register');
Route::post('sign-up', [RegisterController::class, 'store'])->middleware('guest');
Route::get('sign-in', [SessionsController::class, 'create'])->middleware('guest')->name('login');
Route::post('sign-in', [SessionsController::class, 'store'])->middleware('guest');
Route::post('verify', [SessionsController::class, 'show'])->middleware('guest');
Route::post('reset-password', [SessionsController::class, 'update'])->middleware('guest')->name('password.update');
Route::get('verify', function () {
    return view('sessions.password.verify');
})->middleware('guest')->name('verify');
Route::get('/reset-password/{token}', function ($token) {
    return view('sessions.password.reset', ['token' => $token]);
})->middleware('guest')->name('password.reset');

Route::post('sign-out', [SessionsController::class, 'destroy'])->middleware('auth')->name('logout');
Route::get('profile', [ProfileController::class, 'create'])->middleware('auth')->name('profile');
Route::post('user-profile', [ProfileController::class, 'update'])->middleware('auth');
Route::group(['middleware' => 'auth'], function () {
    Route::get('billing', function () {
        return view('pages.billing');
    })->name('billing');
    Route::get('tables', function () {
        return view('pages.tables');
    })->name('tables');
    Route::get('rtl', function () {
        return view('pages.rtl');
    })->name('rtl');
    Route::get('virtual-reality', function () {
        return view('pages.virtual-reality');
    })->name('virtual-reality');
    Route::get('notifications', function () {
        return view('pages.notifications');
    })->name('notifications');
    Route::get('static-sign-in', function () {
        return view('pages.static-sign-in');
    })->name('static-sign-in');
    Route::get('static-sign-up', function () {
        return view('pages.static-sign-up');
    })->name('static-sign-up');
    Route::get('user-management', function () {
        return view('pages.laravel-examples.user-management');
    })->name('user-management');
    Route::get('user-profile', function () {
        return view('pages.laravel-examples.user-profile');
    })->name('user-profile');
});

Route::group(
    ['as' => 'admin.', 'prefix' => 'admin', 'namespace' => 'App\Http\Controllers\Admin', 'middleware' => 'auth'],
    function () {
        // Usuarios
        Route::get('users/procurar', ['as' => 'users.search', 'uses' => 'UserController@search'])->middleware('role:ADMIN');
        Route::resource('users', 'UserController', ['except' => ['show']]);

        // Permissoes
        Route::get('permissoes/procurar', ['as' => 'permissions.search', 'uses' => 'PermissionController@search'])->middleware('role:ADMIN');
        Route::resource('permissions', 'PermissionController');

        // Veiculos
        Route::get('veiculos/procurar', ['as' => 'veiculos.search', 'uses' => 'VeiculoController@search'])->middleware('role:ADMIN');
        Route::resource('veiculos', 'VeiculoController');

        // Empresas
        Route::get('empresas/procurar', ['as' => 'empresas.search', 'uses' => 'EmpresaController@search'])->middleware('role:ADMIN');
        Route::resource('empresas', 'EmpresaController');

        // Pessoas
        Route::prefix('pessoas')->name('pessoas.')->group(function () {
            Route::get('/{tipo}', [PessoaController::class, 'index'])->name('index');
            Route::get('/{tipo}/create', [PessoaController::class, 'create'])->name('create');
            Route::post('store', [PessoaController::class, 'store'])->name('store');
            Route::get('edit/{idpessoa}', [PessoaController::class, 'edit'])->name('edit');
            Route::put('update/{idpessoa}', [PessoaController::class, 'update'])->name('update');
            Route::delete('destroy/{idpessoa}', [PessoaController::class, 'destroy'])->name('destroy');
            Route::get('/{tipo}/search', [PessoaController::class, 'search'])->name('search');
        });

        // Fornecedores
        Route::get('fornecedores/procurar', ['as' => 'fornecedores.search', 'uses' => 'FornecedorController@search'])->middleware('role:ADMIN');
        Route::resource('fornecedores', 'FornecedorController');

        // Funcionários
        Route::get('funcionario/procurar', ['as' => 'funcionarios.search', 'uses' => 'FuncionarioController@search'])->middleware('role:ADMIN');
        Route::resource('funcionarios', 'FuncionarioController');

        // Clientes
        Route::get('clientes/procurar', ['as' => 'clientes.search', 'uses' => 'ClienteController@search'])->middleware('role:ADMIN');
        Route::resource('clientes', 'ClienteController');

        // Contratos
        Route::get('contratos/procurar', ['as' => 'contratos.search', 'uses' => 'ContratoController@search'])->middleware('role:ADMIN');
        Route::resource('contratos', 'ContratoController');

            // NF Item
        Route::delete('contratoveiculo/{idcontratoveiculo}', 'ContratoController@removeitem')->name('contratoveiculo.removeitem');
        Route::post('contratoveiculoadd/{idcontrato}', 'ContratoController@additem')->name('contratoveiculo.additem');
        // Tipo de produtos / servicos
        Route::get('tipo-produto-servico/procurar', ['as' => 'tipo-produto-servico.search', 'uses' => 'TipoProdutoServicoController@search']);
        Route::resource('tipo-produto-servico', 'TipoProdutoServicoController');

        // Produtos / servicos
        Route::get('produto-servico/procurar', ['as' => 'produto-servico.search', 'uses' => 'ProdutoServicoController@search']);
        Route::resource('produto-servico', 'ProdutoServicoController');

        // Compras NF
        Route::get('compras/procurar', ['as' => 'compras.search', 'uses' => 'NfController@search']);
        Route::resource('compras', 'NfController');

        //Route::post('compras/{idnf}/import', [NfController::class, 'importText'])->name('admin.compras.import');

        // NF Item
        Route::delete('nfitem/{idnfitem}', 'NfController@removeitem')->name('nfitem.removeitem');
        Route::post('nfitemadd/{idnf}', 'NfController@additem')->name('nfitem.additem');
        // Route::delete('destroy/{idpessoa}', [PessoaController::class, 'destroy'])->name('destroy');

        // Grupo Itens
        Route::get('grupoitens/procurar', ['as' => 'grupoitens.search', 'uses' => 'GrupoItemController@search']);
        Route::resource('grupoitens', 'GrupoItemController');

        // Grupo Itens
        Route::get('itens/procurar', ['as' => 'itens.search', 'uses' => 'ItemController@search']);
        Route::resource('itens', 'ItemController');

        // Pedidos NF
        Route::get('pedidos/procurar', ['as' => 'pedidos.search', 'uses' => 'PedidoController@search']);
        Route::resource('pedidos', 'PedidoController');

        // Vendas NF
        Route::get('vendas/procurar', ['as' => 'vendas.search', 'uses' => 'VendaController@search']);
        Route::resource('vendas', 'VendaController');

        // Agencias
        Route::get('agencias/procurar', ['as' => 'agencias.search', 'uses' => 'AgenciaController@search']);
        Route::resource('agencias', 'AgenciaController');

        // Forma de pagamento
        Route::get('forma-pagamento/procurar', ['as' => 'forma-pagamento.search', 'uses' => 'FormaPagamentoController@search']);
        Route::resource('forma-pagamento', 'FormaPagamentoController');

        // Parcelas
        Route::get('nfparcelas/procurar', ['as' => 'nfparcelas.search', 'uses' => 'NfParcelaController@search']);
        Route::resource('nfparcelas', 'NfParcelaController');

         // Eventos
         Route::get('eventos/procurar', ['as' => 'eventos.search', 'uses' => 'EventoController@search']);
         Route::resource('eventos', 'EventoController');

          // Eventos Tipos
        Route::get('eventotipos/procurar', ['as' => 'eventotipos.search', 'uses' => 'EventoTipoController@search']);
        Route::resource('eventotipos', 'EventoTipoController');

         // Agencias
         Route::get('agencias/procurar', ['as' => 'agencias.search', 'uses' => 'AgenciaController@search']);
         Route::resource('agencias', 'AgenciaController');

        //Uploads
        Route::delete('delete-upload/{upload}', 'FileUploadTraitController@destroy')->name('delete-upload');
    }
);
