<?php

use App\Models\Nf;
use App\Models\User;
use App\Scopes\TenantScope;
use Detection\MobileDetect;

if (!function_exists('verificarFaturaVencida')) {
    function verificarFaturaVencida(User $user): bool
    {
        if (isset($user)) {
            $pessoa = $user->tenant->idpessoa;

            if (isset($pessoa)) {
                $nf = Nf::withoutGlobalScope(TenantScope::class)
                    ->where('idpessoa', $pessoa)
                    ->where('status', 'ATIVO')
                    ->orderBy('datavencimento')
                    ->first();

                if (isset($nf)) {
                    $diff = date_diff(new DateTime(), new DateTime($nf->datavencimento));
                    $daysToExpire = $diff->days;

                    if ($daysToExpire <= 5) {
                        return true;
                    }
                }
            }
        }

        return false;
    }
}

if (!function_exists('isMobile')) {
    function isMobile()
    {
        $detect = new MobileDetect();
        $isMobile = $detect->isMobile();
        return $isMobile;
    }
}

if (!function_exists('buildNestedQuery')) {
    function buildNestedQuery($conditions)
    {
        return tap(app('db')->query())->where(function($query) use ($conditions) {
            foreach ($conditions as $condition) {
                $method = array_shift($condition);
                $query->{$method}(...$condition);
            }
        });
    }
}

if (!function_exists('filter')) {
    function filter($request, $query)
    {
        $groupPrefixes = $request->input('group-prefix', []);
        $filterPrefixes = $request->input('filter-prefix', []);
        $campos = $request->input('campos', []);
        $operadores = $request->input('operadores', []);
        $valores = $request->input('valores', []);

        if (count($campos) === count($operadores) && count($operadores) === count($valores)) {
            $query->where(function($mainQuery) use ($groupPrefixes, $filterPrefixes, $campos, $operadores, $valores) {
                $currentGroup = null;
                $groupConditions = [];

                foreach ($campos as $index => $campo) {
                    $groupPrefix = $groupPrefixes[$index] ?? $groupPrefixes[count($groupPrefixes) - 1];
                    $filterPrefix = $filterPrefixes[$index];
                    $operador = $operadores[$index];
                    $valor = $valores[$index];

                    if ($currentGroup !== $groupPrefix) {
                        if (!empty($groupConditions)) {
                            $mainQuery->addNestedWhereQuery(buildNestedQuery($groupConditions));
                            $groupConditions = [];
                        }
                        $currentGroup = $groupPrefix;
                    }

                    $method = ($index === 0 || $filterPrefix === 'ONDE') ? 'where' :
                              ($filterPrefix === 'E' ? 'where' : 'orWhere');

                    $condition = [$method, $campo, $operador, $valor];

                    switch ($operador) {
                        case 'like':
                            $condition = [$method, $campo, 'like', '%' . $valor . '%'];
                            break;
                        case 'in':
                            $valoresArray = explode(',', $valor);
                            $condition = [$method . 'In', $campo, $valoresArray];
                            break;
                        case 'between':
                            $valoresArray = explode(',', $valor);
                            if (count($valoresArray) === 2) {
                                $condition = [$method . 'Between', $campo, $valoresArray];
                            }
                            break;
                    }

                    $groupConditions[] = $condition;
                }

                if (!empty($groupConditions)) {
                    $mainQuery->addNestedWhereQuery(buildNestedQuery($groupConditions));
                }
            });
        }
    }
}
