<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\FormaPagamento as Model;
use App\Models\Empresa;

use Exception;
use Illuminate\Support\Facades\DB;

class FormaPagamentoController extends Controller
{


    public function index()
    {
        $formaPagamento = Model::orderBy('formapagamento')
                    ->paginate(100);

        return view('admin.forma-pagamento.index')->with(compact('formaPagamento'));
    }

    public function create()
    {
        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
        ];

        return view('admin.forma-pagamento.create')->with(compact('statusOptions'));
    }

    public function store(Request $request)
    {
        $formaPagamentoCreate = $request->all();

        // Aqui definimos o tenant_id baseado no usuário logado
        $formaPagamentoCreate['idtenant'] = auth()->user()->idtenant;

        try
        {
            Model::create($formaPagamentoCreate);

            return redirect()
                    ->route('admin.forma-pagamento.index')
                    ->with('success', 'Forma de pagamento criada com sucesso!');
        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->withInput()
                    ->with('error', $e->getMessage());
        }
    }

    public function edit($idFormaPagamento)
    {
        $formaPagamento = Model::find($idFormaPagamento);

        if ($formaPagamento->status == 'ATIVO'){
            $bg_status = "bg-success";
        }elseif($formaPagamento->status == 'INATIVO'){
            $bg_status = "bg-danger";
        }else{
            $bg_status = "bg-info";
        }

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];

        return view('admin.forma-pagamento.edit')->with(compact('formaPagamento','bg_status', 'statusOptions'));
    }
    public function update($idFormaPagamento, Request $request)
    {
        $redirect = $request->has('redirect') ? filter_var($request->get('redirect'), FILTER_VALIDATE_BOOLEAN) : true;
        $formaPagamento = Model::find($idFormaPagamento);

        DB::beginTransaction();
        try
        {
            $formaPagamento->update($request->all());

            if ($redirect == false) {
                DB::commit();
                return response()->json($formaPagamento->status);
            }

            DB::commit();
            return redirect()
                    ->route('admin.forma-pagamento.index')
                    ->with('success', 'Forma de pagamento atualizada!');
        } catch(Exception $e)
        {
            DB::rollBack();
            return redirect()
                    ->back()
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function changeStatus($id, $status)
    {
        // Chamando a função updateStatus da trait, passando o modelo e o request
        return $this->updateStatus(Model::class, $id, $status);
    }

    public function destroy($idFormaPagamento)
    {
        $formaPagamento = Model::find($idFormaPagamento);

        try
        {
            $formaPagamento->delete();

            return redirect()
                    ->route('admin.forma-pagamento.index')
                    ->with('success', 'Forma de pagamento removida!');
        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function search(Request $request)
    {
        $formaPagamento =  Model::where('formapagamento', 'like', '%'.$request->search.'%')
                        ->orderBy('formapagamento')
                        ->paginate(100);

        $size = $formaPagamento->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 )
        {
            session()->flash('success', $size.' valores encontrado(s).');

        } else
        {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        return view('admin.forma-pagamento.index')
                ->with(compact('formaPagamento'));
    }
}
