<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Empresa;
use Illuminate\Http\Request;
use App\Models\Pessoa as Model;
use App\Models\TipoPessoa;
use Exception;
use Illuminate\Support\Facades\DB;

class FornecedorController extends Controller
{
    public function index()
    {
        $fornecedores = Model::where('pessoapadrao', false)
                                ->where('status', '!=','INATIVO')
                                ->orderBy('nome')
                                ->Fornecedor()
                                ->paginate(100);

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'POTENCIAL' => 'Potencial',
            'SUSPENSO' => 'Suspenso',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
        ];

        return view('admin.fornecedores.index')->with(compact('fornecedores', 'statusOptions'));
    }

    public function create(Empresa $empresaModel, TipoPessoa $tipoPessoaModel)
    {
        $empresas = $empresaModel
            ->orderBy('razaosocial')
            ->get();

        $tipoPessoa = $tipoPessoaModel
            ->orderBy('tipopessoa')
            ->active()
            ->get();

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
        ];

        $tipo = 'fornecedor';

        return view('admin.fornecedores.create')->with(compact('empresas', 'statusOptions', 'tipo'));
    }

    public function store(Request $request)
    {
        $pessoaCreate = $request->all();


        DB::beginTransaction();
        try {
            $fornecedor = Model::create($pessoaCreate);

            DB::commit();
            return redirect()
                ->route("admin.fornecedores.edit", ['fornecedore' => $fornecedor])
                ->with('success', 'Cadastro efetuado com sucesso!');
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()
                ->back()
                ->withInput()
                ->with('error', $e->getMessage());
        }
    }

    public function edit($idPessoa, Empresa $empresaModel, TipoPessoa $tipoPessoaModel)
    {
        $pessoa = Model::find($idPessoa);
        $empresas = $empresaModel
            ->orderBy('razaosocial')
            ->get();

        $tipoPessoa = $tipoPessoaModel
            ->orderBy('tipopessoa')
            ->active()
            ->get();

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
        ];

        $tipo = 'fornecedor';

        if ($pessoa->status == 'ATIVO') {
            $bg_status = "bg-success";
   
        } else {

            $bg_status = "bg-danger";
        }

        return view('admin.fornecedores.edit',
            compact('pessoa', 'empresas', 'tipoPessoa', 'statusOptions', 'tipo', 'bg_status'));
    }

    public function update($idPessoa, Request $request)
    {
        $redirect = $request->has('redirect') ? filter_var($request->get('redirect'), FILTER_VALIDATE_BOOLEAN) : true;
        $pessoa = Model::find($idPessoa);

        if ($redirect == true) {
            $rotaDeRetorno = $request->tipo == 'F' ? 'fornecedores' : 'clientes';
        }

        DB::beginTransaction();
        try {
            $pessoa->update($request->all());

            if ($redirect == false) {
                DB::commit();
                return response()->json($pessoa->status);
            }

            DB::commit();
            return redirect()
                ->route("admin.$rotaDeRetorno.index")
                ->with('success', 'Pessoa atualizada!');
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()
                ->route('admin.fornecedores.index')
                ->with('error', $e->getMessage())
                ->withInput();
        }
    }

    public function destroy()
    {
    }


    public function search(Request $request)
    {
        $fornecedores = Model::with('empresa')
            ->fornecedor()
            ->where('pessoapadrao', false)
            ->where(function ($query) use ($request) {
                $query->where('nome', 'like', '%' . $request->search . '%')
                    ->orWhere('razaosocial', 'like', '%' . $request->search . '%')
                    ->orWhere('cpfcnpj', 'like', '%' . $request->search . '%')
                    ->orWhereHas('empresa', function ($q) use ($request) {
                        $q->where('nomefantasia', 'like', '%' . $request->search . '%')
                          ->orWhere('razaosocial', 'like', '%' . $request->search . '%');
                    });
            })
            ->where('status', $request->status)
            ->orderBy('nome')
            ->paginate(100);



        $size = $fornecedores->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 )
        {
            session()->flash('success', $size.' valores encontrado(s).');

        } else
        {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'POTENCIAL' => 'Potencial',
            'SUSPENSO' => 'Suspenso',
            'INATIVO' => 'Inativo',
        ];

        return view('admin.fornecedores.index')
                ->with(compact('fornecedores', 'statusOptions'));
    }
}
