<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Funcionalidade;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class FuncionalidadeController extends Controller
{
    public function index(Funcionalidade $funcionalidadeModel)
    {
        $funcionalidades = $funcionalidadeModel
            ->orderBy('nome')
            ->get();

        return view('admin.funcionalidades.index', compact('funcionalidades'));
    }
    public function create()
    {
        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
        ];

        return view('admin.funcionalidades.create', compact('statusOptions'));
    }
    public function store(Request $request)
    {
        $funcionalidadeRequest = $request->all();
        DB::beginTransaction();
        try {
            $newFuncionalidade = Funcionalidade::create($funcionalidadeRequest);
            DB::commit();
            return redirect()->route('admin.funcionalidades.edit', $newFuncionalidade)->with('success', 'Funcionalidade criada com sucesso!');
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function edit(Funcionalidade $funcionalidade)
    {
        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
        ];

        if ($funcionalidade->status == 'ATIVO'){
            $bg_status = "bg-success";
        }elseif($funcionalidade->status == 'INATIVO'){
            $bg_status = "bg-danger";
        }else{
            $bg_status = "bg-info";
        }

        return view('admin.funcionalidades.edit', compact('funcionalidade', 'statusOptions', 'bg_status'));
    }
    public function update(Funcionalidade $funcionalidade, Request $request)
    {
        $redirect = $request->has('redirect') ? filter_var($request->get('redirect'), FILTER_VALIDATE_BOOLEAN) : true;
        $funcionalidadeRequest = $request->all();

        DB::beginTransaction();
        try {
            $funcionalidade->update($funcionalidadeRequest);

            if ($redirect == false) {
                DB::commit();
                return response()->json($funcionalidade->status);
            }

            DB::commit();
            return redirect()->route('admin.funcionalidades.edit', ['funcionalidade' => $funcionalidade])->with('success', 'Funcionalidade atualizada com sucesso!');
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    public function destroy(Funcionalidade $funcionalidade)
    {
        DB::beginTransaction();
        try {
            $funcionalidade->delete();
            DB::commit();
            return redirect()->route('admin.funcionalidades.index')->with('success', 'Funcionalidade excluída com sucesso!');
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function search(Request $request)
    {
        $query = $request->search;

        $funcionalidades = Funcionalidade::where('idfuncionalidade', 'like', "%{$query}%")
            ->orWhere('nome', 'like', "%{$query}%")
            ->orWhere('alias', 'like', "%{$query}%")
            ->orWhere('status', 'like', "%{$query}%")
            ->get();

        return view('admin.funcionalidades.index', compact('funcionalidades', 'query'));
    }

}
