<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Empresa;
use Illuminate\Http\Request;
use App\Models\GrupoItem as Model;
use Exception;
use Illuminate\Support\Facades\DB;

class GrupoItemController extends Controller
{
    public function index()
    {
    // Aplicando Eager Loading para carregar a relação 'empresa' junto com 'grupoItens'
    $grupoItens = Model::with('empresa') // Eager Loading para 'empresa'
                    ->orderBy('grupoitem')
                    ->paginate(100);

        return view('admin.grupoitens.index')->with(compact('grupoItens'));
    }

    public function create(Empresa $empresaModel)
    {
        $empresas = $empresaModel
                        ->orderBy('razaosocial')
                        ->get();

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];

        return view('admin.grupoitens.create')->with(compact('empresas', 'statusOptions'));
    }

    public function store(Request $request)
    {
        $grupoItensCreate = $request->all();

        try
        {
            $grupoItem = Model::create($grupoItensCreate);

            return redirect()->to('admin/grupoitens/'.$grupoItem->idgrupoitem.'/edit');

        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->withInput()
                    ->with('error', $e->getMessage());
        }
    }

    public function edit($idGrupoItem, Empresa $empresaModel)
    {

        $grupoItem = Model::find($idGrupoItem);


        $empresas = $empresaModel
                    ->orderBy('razaosocial')
                    ->get();

        if ($grupoItem->status == 'ATIVO'){
            $bg_status = "bg-success";
        }elseif($grupoItem->status == 'INATIVO'){
            $bg_status = "bg-danger";
        }else{
            $bg_status = "bg-info";
        }

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];

        return view('admin.grupoitens.edit')->with(compact('grupoItem', 'empresas', 'bg_status', 'statusOptions'));
    }

    public function update($idGrupoItem, Request $request)
    {
        $redirect = $request->has('redirect') ? filter_var($request->get('redirect'), FILTER_VALIDATE_BOOLEAN) : true;
        $grupoItem = Model::find($idGrupoItem);

        DB::beginTransaction();
        try {
            $grupoItem->update($request->all());

            if ($redirect == false) {
                DB::commit();
                return response()->json($grupoItem->status);
            }

            DB::commit();
            return back()->with('success', 'Evento atualizado!');
        } catch(Exception $e) {
            DB::rollBack();
            return redirect()
                    ->route('admin.grupoitens.index')
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function destroy($idEvento)
    {
        $grupoItem = Model::find($idEvento);

        try
        {
            $grupoItem->delete();

            return redirect()
                    ->route('admin.grupoitens.index')
                    ->with('success', 'Evento removido!');
        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function search(Request $request)
    {
        $grupoItens =  Model::with('empresa')
                        ->where('grupoitem', 'like', '%'.$request->search.'%')
                        ->orderBy('grupoitem')
                        ->paginate(100);

        $size = $grupoItens->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 )
        {
            session()->flash('success', $size.' valor(es) encontrado(s).');

        } else
        {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        return view('admin.grupoitens.index')
                ->with(compact('grupoItens'));
    }
}
