<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Empresa;
use App\Models\GrupoItem;
use Illuminate\Http\Request;
use App\Models\Item as Model;
use Exception;
use Illuminate\Support\Facades\DB;

class ItemController extends Controller
{
    public function index()
    {
        $itens = Model::with('empresa')
                    ->orderBy('item')
                    ->paginate(1000);

        return view('admin.itens.index')->with(compact('itens'));
    }

    public function create(Empresa $empresaModel, GrupoItem $grupoItemModel)
    {
        $empresas = $empresaModel
                        ->orderBy('razaosocial')
                        ->get();

        $grupoitens = $grupoItemModel
                        ->orderBy('grupoitem')
                        ->get();

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];

        return view('admin.itens.create')->with(compact('empresas','grupoitens', 'statusOptions'));
    }

    public function store(Request $request)
    {
        $itensCreate = $request->all();

        try
        {
            $item = Model::create($itensCreate);

            return redirect()->to('admin/itens/'.$item->iditem.'/edit');

        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->withInput()
                    ->with('error', $e->getMessage());
        }
    }

    public function edit($idItem, Empresa $empresaModel, GrupoItem $grupoItemModel)
    {

        $item = Model::find($idItem);


        $empresas = $empresaModel
                    ->orderBy('razaosocial')
                    ->get();

        $grupoitens = $grupoItemModel
                    ->orderBy('grupoitem')
                    ->get();


        if ($item->status == 'ATIVO'){
            $bg_status = "bg-success";
        }elseif($item->status == 'INATIVO'){
            $bg_status = "bg-danger";
        }else{
            $bg_status = "bg-info";
        }

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];

        return view('admin.itens.edit')->with(compact('item', 'empresas', 'bg_status','grupoitens', 'statusOptions'));
    }

    public function update($idItem, Request $request)
    {
        $redirect = $request->has('redirect') ? filter_var($request->get('redirect'), FILTER_VALIDATE_BOOLEAN) : true;
        $item = Model::find($idItem);

        DB::beginTransaction();
        try {
            $item->update($request->all());

            if ($redirect == false) {
                DB::commit();
                return response()->json($item->status);
            }

            DB::commit();
            return back()->with('success', 'Item atualizado!');

        } catch(Exception $e) {
            DB::rollBack();
            return redirect()
                    ->route('admin.itens.index')
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function destroy($idItem)
    {
        $item = Model::find($idItem);

        try
        {
            $item->delete();

            return redirect()
                    ->route('admin.itens.index')
                    ->with('success', 'Item removido!');
        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function search(Request $request)
    {
        $itens =  Model::with('empresa')->where('item', 'like', '%'.$request->search.'%')
                        ->orderBy('item')
                        ->paginate(100);

        $size = $itens->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 )
        {
            session()->flash('success', $size.' valor(es) encontrado(s).');

        } else
        {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        return view('admin.itens.index')
                ->with(compact('itens'));
    }
}
