<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Empresa;
use Illuminate\Http\Request;
use App\Models\Pessoa as Model;
use App\Models\TipoPessoa;
use Exception;
use Illuminate\Support\Facades\DB;

class PessoaController extends Controller
{
    public function index($tipo = 'cliente')
    {
        $pessoas = Model::where('pessoapadrao', false)->orderBy('nome');

        if ($tipo === 'fornecedor')
            $pessoas->fornecedor();
        else
            $pessoas->cliente();

        $pessoas = $pessoas->paginate(100);

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'POTENCIAL' => 'Potencial',
            'SUSPENSO' => 'Suspenso',
            'INATIVO' => 'Inativo',
        ];

        return view('admin.pessoas.index')->with(compact('pessoas', 'statusOptions', 'tipo'));
    }

    public function create($tipo, Empresa $empresaModel, TipoPessoa $tipoPessoaModel)
    {
        $empresas = $empresaModel
            ->orderBy('razaosocial')
            ->get();

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'POTENCIAL' => 'Potencial',
            'INATIVO' => 'Inativo',
            'SUSPENSO' => 'Suspenso'
            // Adicione mais status conforme necessário
        ];
        return view('admin.pessoas.create')->with(compact('empresas', 'tipo', 'statusOptions'));
    }

    public function store(Request $request)
    {
        $pessoaCreate = $request->all();

        try {
            Model::create($pessoaCreate);

            // @TODO: Gerar usuario com permissões padroes

            return redirect()
                ->route("admin.pessoas.index", ['tipo' => $pessoaCreate['tipo']])
                ->with('success', 'Cadastro efetuado com sucesso!');
        } catch (Exception $e) {
            return redirect()
                ->back()
                ->withInput()
                ->with('error', $e->getMessage());
        }
    }

    public function edit($idPessoa, Empresa $empresaModel, TipoPessoa $tipoPessoaModel)
    {
        $pessoa = Model::find($idPessoa);
        $empresas = $empresaModel
            ->orderBy('razaosocial')
            ->get();

        if ($pessoa->status == 'ATIVO'){
            $bg_status = "bg-success";
        }elseif($pessoa->status == 'INATIVO'){
            $bg_status = "bg-danger";
        }else{
            $bg_status = "bg-info";
        }

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'POTENCIAL' => 'Potencial',
            'INATIVO' => 'Inativo',
            'SUSPENSO' => 'Suspenso'
            // Adicione mais status conforme necessário
        ];


        return view('admin.pessoas.edit')->with(compact('pessoa', 'empresas','bg_status', 'statusOptions'));
    }

    public function update($idPessoa, Request $request)
    {
        $redirect = $request->has('redirect') ? filter_var($request->get('redirect'), FILTER_VALIDATE_BOOLEAN) : true;
        $pessoa = Model::find($idPessoa);
        $pessoaUpdate = $request->all();

        DB::beginTransaction();
        try {
            $pessoa->update($pessoaUpdate);

            if ($redirect == false) {
                DB::commit();
                return response()->json($pessoa->status);
            }

            DB::commit();
            return back()->with('success', 'Pessoa atualizada!');

        } catch (Exception $e) {
            DB::rollBack();
            return redirect()
                ->route('admin.pessoas.edit', ['idpessoa' => $pessoa])
                ->with('error', $e->getMessage())
                ->withInput();
        }
    }

    public function destroy()
    {
    }



    public function search(Request $request, $tipo = 'cliente')
    {
        $query =  Model::query()
        ->select('pessoa.*')
        ->join('empresa', 'empresa.idempresa', '=', 'pessoa.idempresa')
        ->where('pessoapadrao', false)
        ->where(function ($query) use ($request) {
            $query->where('nome', 'like', '%' . $request->search . '%') // Adicionando a busca por 'marca'
            ->orwhere('pessoa.razaosocial', 'like', '%' . $request->search . '%')
            ->orwhere('cpfcnpj', 'like', '%' . $request->search . '%')
            ->orwhereHas('empresa', function ($q) use ($request) {
                $q->where('nomefantasia', 'like', '%' . $request->search . '%');
            })
            ->orWhereHas('empresa', function ($q) use ($request) {
                $q->where('empresa.razaosocial', 'like', '%' . $request->search . '%');
            });
        })
        ->where('pessoa.status', $request->status);


        if ($tipo === 'fornecedor') {
            $query->fornecedor();
        } else {
            $query->cliente();
        }

        $pessoas = $query->orderBy('empresa.sigla')
        ->orderBy('nome')
        ->paginate(100);

        $size = $pessoas->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 )
        {
            session()->flash('success', $size.' valores encontrado(s).');

        } else
        {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'POTENCIAL' => 'Potencial',
            'SUSPENSO' => 'Suspenso',
            'INATIVO' => 'Inativo',
        ];

        return view('admin.pessoas.index')
                ->with(compact('pessoas', 'statusOptions','tipo'));
    }


    public function get($id)
    {
        $pessoas = Model::where('idempresa', $id)
        ->orderBy('nome')
        ->funcionarioOuCliente()
        ->get();

        // Retorna como JSON
        return response()->json([
            'data' => $pessoas
        ]);
    }

}
