<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Plano;
use App\Models\ProdutoServico;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PlanoController extends Controller
{

    public function index(Plano $planoModel)
    {
        $planos = $planoModel
            ->orderBy('nome')
            ->get();

        return view('admin.planos.index', compact('planos'));
    }

    public function create(ProdutoServico $produtoServicoModel)
    {
        $prodservs = $produtoServicoModel
            ->orderBy('prodserv')
            ->get();

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
        ];

        return view('admin.planos.create', compact('prodservs', 'statusOptions'));
    }

    public function store(Request $request)
    {
        $planoRequest = $request->all();

        // Campos monetários
        $planoRequest['valor'] = str_replace(['.', ','], ['', '.'], $planoRequest['valor']); // Ex: 1.000,00 para 1000.00

        DB::beginTransaction();
        try {
            $plano = Plano::create($planoRequest);
            DB::commit();
            return redirect()->route('admin.planos.edit', $plano)->with('success', 'Plano criado com sucesso!');
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()->back()->with('error', $e->getMessage());
        }

    }

    public function edit(Plano $plano, ProdutoServico $produtoServicoModel)
    {
        $prodservs = $produtoServicoModel
            ->orderBy('prodserv')
            ->get();

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
        ];

        if ($plano->status == 'ATIVO'){
            $bg_status = "bg-success";
        }elseif($plano->status == 'INATIVO'){
            $bg_status = "bg-danger";
        }else{
            $bg_status = "bg-info";
        }

        return view('admin.planos.edit', compact('plano', 'prodservs', 'statusOptions', 'bg_status'));
    }

    public function update(Plano $plano, Request $request)
    {

         // Tratamento para toggle coletiva
         if (isset($request['gratuito']) && $request['gratuito'] == 'on') {
            $request['gratuito'] = true;
        } else {
            $request['gratuito'] = false;
        }


        $redirect = $request->has('redirect') ? filter_var($request->get('redirect'), FILTER_VALIDATE_BOOLEAN) : true;
        $planoRequest = $request->all();

        if ($redirect == true) {
            // Campos monetários
            $planoRequest['valor'] = str_replace(['.', ','], ['', '.'], $planoRequest['valor']); // Ex: 1.000,00 para 1000.00
        }

        DB::beginTransaction();
        try {
            $plano->update($planoRequest);

            if ($redirect == false) {
                DB::commit();
                return response()->json($plano->status);
            }

            DB::commit();
            return redirect()->route('admin.planos.edit', ['plano' => $plano])->with('success', 'Plano atualizado com sucesso!');
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function destroy(Plano $plano)
    {
        DB::beginTransaction();
        try {
            $plano->delete();
            DB::commit();
            return redirect()->route('admin.planos.index')->with('success', 'Plano excluído com sucesso!');
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function search(Request $request, Plano $plano)
    {
        // Definindo os filtros
        $query = $request->search;

        $planos = $plano
            ->with('prodserv',)
            ->whereHas('prodserv', function($subQuery) use ($query) {
                $subQuery->where('prodserv', 'like', "%{$query}%");
            })
            ->orWhere('nome', 'like', "%{$query}%")
            ->orWhere('valor', 'like', "%{$query}%")
            ->orWhere('status', 'like', "%{$query}%")
            ->get();

        // Retornando os filtros e os registros
        return view('admin.planos.index', compact('planos'));
    }
}
