<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Empresa;
use App\Models\Pessoa;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class RepresentanteController extends Controller
{
    public function index()
    {
        $representantes = Pessoa::representante()->get();

        $statusOptions = [
            'INATIVO' => 'Inativo',
            'SUSPENSO' => 'Suspenso',
            'POTENCIAL' => 'Potencial',
            'ATIVO' => 'Ativo',
        ];

        return view('admin.representantes.index', compact('representantes', 'statusOptions'));
    }

    public function create()
    {
        $empresas = Empresa::orderBy('razaosocial')->get();

        $statusOptions = [
            'INATIVO' => 'Inativo',
            'SUSPENSO' => 'Suspenso',
            'POTENCIAL' => 'Potencial',
            'ATIVO' => 'Ativo',
        ];

        return view('admin.representantes.create', compact('empresas', 'statusOptions'));
    }

    public function store(Request $request)
    {
        $representanteRequest = $request->all();

        DB::beginTransaction();
        try {
            $representante = Pessoa::create($representanteRequest);
            DB::commit();
            return redirect()->route('admin.representantes.edit', $representante)
                    ->with('success', 'Representante criado com sucesso!');
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function edit(Pessoa $representante)
    {
        $empresas = Empresa::orderBy('razaosocial')->get();

        $statusOptions = [
            'INATIVO' => 'Inativo',
            'SUSPENSO' => 'Suspenso',
            'POTENCIAL' => 'Potencial',
            'ATIVO' => 'Ativo',
        ];

        if ($representante->status == 'ATIVO') {
            $bg_status = "bg-success";
        } elseif ($representante->status == 'POTENCIAL') {
            $bg_status = "bg-info";
        } elseif ($representante->status == 'SUSPENSO') {
            $bg_status = "bg-warning";
        } elseif ($representante->status == 'INATIVO') {
            $bg_status = "bg-danger";
        }

        return view('admin.representantes.edit', compact('representante', 'empresas', 'statusOptions', 'bg_status'));
    }

    public function update(Request $request, Pessoa $representante)
    {
        $redirect = $request->has('redirect') ? filter_var($request->get('redirect'), FILTER_VALIDATE_BOOLEAN) : true;
        $representanteRequest = $request->all();

        DB::beginTransaction();
        try {
            $representante->update($representanteRequest);
            DB::commit();

            if ($redirect == false) {
                return response()->json($representante->status);
            }

            return redirect()->route('admin.representantes.edit', $representante);
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function destroy(Pessoa $representante)
    {
        DB::beginTransaction();
        try {
            $representante->delete();
            DB::commit();
            return redirect()->route('admin.representantes.index')
                    ->with('success', 'Representante excluido com sucesso!');
        } catch (Exception $e) {
            DB::rollBack();
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
}
