<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Empresa;
use Illuminate\Http\Request;
use App\Models\TipoProdutoServico as Model;
use Exception;
use Illuminate\Support\Facades\DB;

class TipoProdutoServicoController extends Controller
{
    public function index()
    {
        $tiposProdutoServico = Model::orderBy('prodservtipo')
                    ->paginate(100);

        return view('admin.tipo-produto-servico.index')->with(compact('tiposProdutoServico'));
    }

    public function create(Empresa $empresaModel)
    {
        $empresas = $empresaModel
                        ->orderBy('razaosocial')
                        ->get();

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];
        return view('admin.tipo-produto-servico.create')->with(compact('empresas', 'statusOptions'));
    }

    public function store(Request $request)
    {
        $tipoProdutoServicoCreate = $request->all();

        try
        {
            $prodservtipo = Model::create($tipoProdutoServicoCreate);

            return redirect()->to('admin/tipo-produto-servico/'.$prodservtipo->idprodservtipo.'/edit');

        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->withInput()
                    ->with('error', $e->getMessage());
        }
    }

    public function edit($idProdutoServico, Empresa $empresaModel)
    {
        $tipoProdutoServico = Model::find($idProdutoServico);
        $empresas = $empresaModel
                    ->orderBy('razaosocial')
                    ->get();

        if ($tipoProdutoServico->status == 'ATIVO'){
            $bg_status = "bg-success";
        }elseif($tipoProdutoServico->status == 'INATIVO'){
            $bg_status = "bg-danger";
        }else{
            $bg_status = "bg-info";
        }

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];

        return view('admin.tipo-produto-servico.edit')->with(compact('tipoProdutoServico', 'empresas', 'bg_status', 'statusOptions'));
    }

    public function update($idProdutoServico, Request $request)
    {
        $redirect = $request->has('redirect') ? filter_var($request->get('redirect'), FILTER_VALIDATE_BOOLEAN) : true;
        $tipoProdutoServico = Model::find($idProdutoServico);
        $tipoProdutoServicoRequest = $request->all();

        DB::beginTransaction();
        try {
            $tipoProdutoServico->update($tipoProdutoServicoRequest);

            if ($redirect == false) {
                DB::commit();
                return response()->json($tipoProdutoServico->status);
            }

            DB::commit();
            return back()->with('success', 'Tipo Produto/Serviço atualizado!');

        } catch(Exception $e) {
            DB::rollBack();
            return redirect()
                    ->route('admin.tipo-produto-servico.index')
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function destroy($idProdutoServico)
    {
        $tipoProdutoServico = Model::find($idProdutoServico);

        try
        {
            $tipoProdutoServico->delete();

            return redirect()
                    ->route('admin.tipo-produto-servico.index')
                    ->with('success', 'Tipo Produto/Serviço removido!');
        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function search(Request $request)
    {
        $tiposProdutoServico =  Model::query()
        ->join('empresa', 'empresa.idempresa', '=', 'prodservtipo.idempresa')
        ->where(function ($query) use ($request) {
            $query->where('prodservtipo', 'like', '%' . $request->search . '%') // Adicionando a busca por 'marca'
            ->orwhereHas('empresa', function ($q) use ($request) {
                $q->where('nomefantasia', 'like', '%' . $request->search . '%');
            })
            ->orWhereHas('empresa', function ($q) use ($request) {
                $q->where('razaosocial', 'like', '%' . $request->search . '%');
            });
        })
        ->orderBy('empresa.sigla')
        ->orderBy('prodservtipo')
        ->paginate(100);

        $size = $tiposProdutoServico->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 )
        {
            session()->flash('success', $size.' valor(es) encontrado(s).');

        } else
        {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        return view('admin.tipo-produto-servico.index')
                ->with(compact('tiposProdutoServico'));
    }
}
