<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\User;
use App\Models\Empresa;
use App\Models\Pessoa;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use illuminate\support\Str;

class UserController extends Controller
{
    protected $usersModel;

    public function __construct(User $usersModel)
    {
        $this->usersModel = $usersModel;
    }

    public function index(User $model)
    {
        $users = $this->usersModel->getAll('paginate', 100);

        return view('admin.users.index')
                ->with(compact('users'));
    }

    public function create(Empresa $empresaModel)
    {
        $roles = Role::all();

        $empresas = $empresaModel
        ->orderBy('razaosocial')
        ->get();

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
            // Adicione mais status conforme necessário
        ];

        $pessoas = Pessoa::query()->representante()->get();

        return view('admin.users.create')
                ->with(compact('roles', 'empresas', 'statusOptions', 'pessoas'));
    }

    public function store(Request $request, User $model)
    {
        $role = Role::find($request->input('role_id'));

        //$data = $request->merge(['password' => Hash::make($request->get('password'))])->all();
        $data = $request->all();

        // Autorizando usuario para api
        if($role->name == 'ADMIN' || $role->name == 'FUNCIONARIO')
        {
            $data['api_token'] = Str::random(80);
        } else
        {
            $data['api_token'] = null;
        }

        // Aqui definimos o tenant_id baseado no usuário logado
        $data['idtenant'] = auth()->user()->idtenant;

        $model->create($data)
            ->assignRole($role->name);

        return redirect()->route('admin.users.index')->with('success', 'Usuário criado com sucesso.');
    }

    public function edit($id, Empresa $empresaModel)
    {
        $roles = Role::all();
        $user = $this->usersModel->find($id);
        $userRole = $user->getRoleNames();

        $empresas = $empresaModel
                    ->orderBy('razaosocial')
                    ->get();


        if ($user->status == 'ATIVO'){
            $bg_status = "bg-success";
        }elseif($user->status == 'INATIVO'){
            $bg_status = "bg-danger";
        }else{
            $bg_status = "bg-info";
        }

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];

        $pessoas = Pessoa::query()->representante()->get();

        return view('admin.users.edit')
                ->with(compact('roles','userRole', 'user', 'empresas','bg_status', 'statusOptions', 'pessoas'));
    }

    public function update(Request $request, $id)
    {
        $redirect = $request->has('redirect') ? filter_var($request->get('redirect'), FILTER_VALIDATE_BOOLEAN) : true;
        $data = $request->all();
        $user = $this->usersModel->find($id);

        if ($redirect == true) {
            $userRole = $user->getRoleNames()->first();
            // $hasPassword = $request->get('password');
            $role = Role::find($request->role_id);

            /* $data = $request->merge(
                ['password' => Hash::make($request->get('password'))]
                )->except([$hasPassword ? '' : 'password']
            );
            */
        }

        DB::beginTransaction();
        try {
            $user->update($data);

            if ($redirect == false) {
                DB::commit();
                return response()->json($user->status);
            }

            if($userRole != $role->name || !$user->hasRole($role->name)) {
                if($userRole)
                    $user->removeRole($userRole);

                $user->assignRole($role->name);
            }

            DB::commit();
            return back()->with('success', 'Usuário atualizado!');
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function changePassword(Request $request, $id)
    {
        DB::beginTransaction();
        try {
            $user = $this->usersModel->find($id);
            $user->password = $request->get('password');
            $user->save();

            DB::commit();
            return back()->with('success', 'Senha alterada com sucesso!');
        } catch (\Exception $e) {
            DB::rollBack();
            return back()->with('error', $e->getMessage());
        }
    }

    public function destroy(User $user)
    {
        $user->delete();
        return redirect()
                ->route('admin.users.index')
                ->with('success', 'Usuário apagado com sucesso.');
    }

    public function search(Request $request)
    {
        $filters = [
            'filter' => 'name',
            'query' => $request->search
        ];
        $users = $this->usersModel->filter($filters, 'paginate', 100);

        $size = $users->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 )
        {
            session()->flash('success', $size.' valores encontrado(s).');

        } else
        {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        return view('admin.users.index')
                ->with(compact('users'));
    }
}
