<?php

namespace App\Http\Livewire;

use App\Models\Agencia;
use App\Models\Contrato;
use App\Models\ContratoVeiculo;
use Livewire\Component;
use App\Models\Empresa;
use App\Models\User;
use App\Models\Veiculo;
use App\Services\DateRangeService;

class DashboardFilters extends Component
{
    public $datarange;
    public $idempresa;
    public $userId;
    public $idcontrato;
    public $idveiculo;
    public $origemuf;
    public $destinouf;
    public $idagencia;
    public $showAgencias;
    public $showContratos;
    public $showVeiculos;
    public $showUsers;
    public $showEmpresas;

    public function mount($showAgencias = true, $showContratos = true, $showVeiculos = true, $showUsers = true, $showEmpresas = true)
    {
        $this->showAgencias = $showAgencias;
        $this->showContratos = $showContratos;
        $this->showVeiculos = $showVeiculos;
        $this->showUsers = $showUsers;
        $this->showEmpresas = $showEmpresas;
    }

    public function render(Empresa $empresaModel, User $userModel, Veiculo $veiculoModel, Contrato $contratoModel, ContratoVeiculo $contratoVeiculoModel, Agencia $agenciaModel)
    {
        $dados = DateRangeService::generateDateRange($this->datarange);

        $users = $userModel->orderBy('name')->get();

        $empresas = $empresaModel
            ->when($this->idveiculo, function ($query) {
                return $query->leftJoin('veiculo', 'empresa.idempresa', '=', 'veiculo.idempresa')
                            ->where('veiculo.idveiculo', $this->idveiculo);
            })
            ->when($this->idcontrato, function ($query) {
                return $query->leftJoin('contrato', 'contrato.idempresa', '=', 'empresa.idempresa')
                            ->where('contrato.idcontrato', $this->idcontrato);
            })
            ->when($this->idagencia, function ($query) {
                return $query->leftJoin('nfparcela', 'empresa.idempresa', '=', 'nfparcela.idempresa')
                            ->where('nfparcela.idagencia', $this->idagencia); // Use 'nfparcela.idagencia'
            })
            ->orderBy('empresa.sigla')
            ->orderBy('empresa.razaosocial')
            ->get();


        $contratos = $contratoModel
            ->when($this->idempresa, function ($query) {
                return $query->where('idempresa', $this->idempresa);
            })
            ->orderBy('idcontrato', 'asc')
            ->get();

        $veiculos = $contratoVeiculoModel
            ->when(!$this->idcontrato && !$this->idempresa, function ($query) use ($veiculoModel) {
                return $veiculoModel->orderBy('placa', 'asc')
                                    ->orderBy('marca', 'asc')
                                    ->orderBy('modelo', 'asc');
            })
            ->when($this->idempresa && !$this->idcontrato, function ($query) use ($veiculoModel) {
                return $veiculoModel->where('idempresa', $this->idempresa)
                                    ->orderBy('placa', 'asc')
                                    ->orderBy('marca', 'asc')
                                    ->orderBy('modelo', 'asc');
            })
            ->when($this->idcontrato, function ($query) {
                $query->leftJoin('veiculo', 'contratoveiculo.idveiculo', '=', 'veiculo.idveiculo')
                    ->leftJoin('empresa', 'contratoveiculo.idempresa', '=', 'empresa.idempresa')
                    ->where('contratoveiculo.idcontrato', $this->idcontrato);
            })
            ->orderBy('veiculo.placa', 'asc')
            ->orderBy('veiculo.marca', 'asc')
            ->orderBy('veiculo.modelo', 'asc')
            ->get();

        // Filtro para Agências
        $agencias = $agenciaModel
            ->when(!$this->idagencia && !$this->idempresa, function ($query) use ($agenciaModel) {
                return $agenciaModel->orderBy('nome', 'asc');
            })
            // Caso onde apenas o idempresa foi fornecido
            ->when($this->idempresa && !$this->idagencia, function ($query) {
                return $query->leftJoin('nfparcela', 'agencia.idagencia', '=', 'nfparcela.idagencia')
                            ->where('nfparcela.idempresa', $this->idempresa);
            })
            ->orderBy('nome', 'asc')
            ->get();

        return view('livewire.dashboard-filters', [
            'empresas' => $empresas,
            'users' => $users,
            'veiculos' => $veiculos,
            'contratos' => $contratos,
            'agencias' => $agencias,
            'dados' => $dados
        ]);
    }


    public function applyFilters()
    {
        // dd($this->datarange);
        // Emitir um evento para o navegador.
        $this->emit('filtersApplied', [
            'datarange' => $this->datarange,
            'idempresa' => $this->idempresa ?? null,
            'idcontrato' => $this->idcontrato ?? null,
            'idveiculo' => $this->idveiculo ?? null,
            'idagencia' => $this->idagencia ?? null,
            'userId' => $this->userId,
            'origemuf' => $this->origemuf,
            'destinouf' => $this->destinouf,
        ]);
    }




}
