<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\Evento;
use Carbon\Carbon;

class EventoComponent extends Component
{
    public $eventosMesAtual;
    public $eventosMesPassado;
    public $totalEventosMesAtual;
    public $totalEventosMesPassado;
    public $percentualEventosMudanca;
    public $eventosEmAbertoMesAtual;
    public $eventosEmAbertoMesPassado;
    public $eventosFaturadosMesAtual;
    public $eventosFaturadosMesPassado;
    public $eventosPendentes;
    public $eventosEmExecucao;
    public $eventosVencer;
    public $eventosVencidos;

    public $qtdEventosMesAtual; 
    public $qtdEventosMesPassado;
    public $percentualQtdEventosMudanca;
    public $qtdEventosEmAbertoMesAtual;
    public $qtdEventosEmAbertoMesPassado;
    public $percentualQtdEventosEmAbertoMudanca;
    public $qtdEventosFaturadosMesAtual;
    public $qtdEventosFaturadosMesPassado;
    public $percentualQtdEventosFaturadosMudanca;

    public $totalEventosEmAbertoMesAtual;
    public $totalEventosEmAbertoMesPassado;
    public $percentualEventosEmAbertoMudanca;
    public $totalEventosFaturadosMesAtual;
    public $totalEventosFaturadosMesPassado;    
    public $percentualEventosFaturadosMudanca;

    public $qtdEventosPendentes;
    public $qtdEventosEmExecucao;
    public $qtdEventosVencer;
    public $qtdEventosVencidos;

    public function mount()
    {
        $inicioMesAtual = Carbon::now()->startOfMonth();
        $finalMesAtual = Carbon::now()->endOfMonth();

        $inicioMesPassado = Carbon::now()->subMonthNoOverflow()->startOfMonth();
        $finalMesPassado = Carbon::now()->subMonthNoOverflow()->endOfMonth();

        // Eventos deste mês
        $this->eventosMesAtual = $this->buscarEventos($inicioMesAtual, $finalMesAtual);

        // Eventos do mês passado
        $this->eventosMesPassado = $this->buscarEventos($inicioMesPassado, $finalMesPassado);

        // Eventos deste mês em Aberto
        $this->eventosEmAbertoMesAtual = $this->buscarEventos($inicioMesAtual, $finalMesAtual, 'aberto'); // Eventos em aberto

        // Eventos do mês passado em Aberto
        $this->eventosEmAbertoMesPassado  = $this->buscarEventos('', $finalMesPassado, 'aberto'); // Eventos em aberto

        // Eventos do mês passado Faturados
        $this->eventosFaturadosMesAtual = $this->buscarEventos($inicioMesAtual, $finalMesAtual, 'faturado'); // Eventos faturados

        // Eventos do mês passado Faturados
        $this->eventosFaturadosMesPassado = $this->buscarEventos($inicioMesPassado, $finalMesPassado, 'faturado'); // Eventos faturados


        // Eventos deste mês em Aberto
        $this->eventosPendentes = $this->buscarEventos(null,null,null,'PENDENTE'); // Eventos em aberto
        // Eventos deste mês em Aberto
        $this->eventosEmExecucao = $this->buscarEventos(null,null,null,'EM EXECUÇÃO'); // Eventos em aberto

          // Eventos deste mês em Aberto
          $this->eventosVencer = $this->buscarEventos(null,null,'vencer',null); // Eventos em aberto
          // Eventos deste mês em Aberto
          $this->eventosVencidos = $this->buscarEventos(null,null,'vencido',null); // Eventos em aberto
        


        // Calcula o total para o mês atual
        $this->totalEventosMesAtual = $this->calcularTotalEventos($this->eventosMesAtual);
        $this->qtdEventosMesAtual = $this->calcularQuantidadeEventos($this->eventosMesAtual);
        // Calcula o total para o mês passado
        $this->totalEventosMesPassado = $this->calcularTotalEventos($this->eventosMesPassado);
        $this->qtdEventosMesPassado = $this->calcularQuantidadeEventos($this->eventosMesAtual); $this->eventosMesPassado->count();
        // Calcula o percentual de mudança
        $this->percentualEventosMudanca = $this->calcularPercentualMudanca($this->totalEventosMesPassado, $this->totalEventosMesAtual);
        $this->percentualQtdEventosMudanca = $this->calcularPercentualMudanca($this->qtdEventosMesPassado, $this->qtdEventosMesAtual);
      
        // Calcula o total para o mês atual
        $this->totalEventosEmAbertoMesAtual = $this->calcularTotalEventos($this->eventosEmAbertoMesAtual);
        $this->qtdEventosEmAbertoMesAtual = $this->calcularQuantidadeEventos($this->eventosEmAbertoMesAtual); 
        // Calcula o qtd para o mês passado
        $this->totalEventosEmAbertoMesPassado = $this->calcularTotalEventos($this->eventosEmAbertoMesPassado);
        $this->qtdEventosEmAbertoMesPassado = $this->calcularQuantidadeEventos($this->eventosEmAbertoMesPassado);
        // Calcula o percentual de mudança
        $this->percentualEventosEmAbertoMudanca = $this->calcularPercentualMudanca($this->totalEventosEmAbertoMesPassado, $this->totalEventosEmAbertoMesAtual);
        $this->percentualQtdEventosEmAbertoMudanca = $this->calcularPercentualMudanca($this->qtdEventosEmAbertoMesPassado, $this->qtdEventosEmAbertoMesAtual);
       
       
        // Calcula o total para o mês atual
        $this->totalEventosFaturadosMesAtual = $this->calcularTotalEventos($this->eventosFaturadosMesAtual);
        $this->qtdEventosFaturadosMesAtual = $this->calcularQuantidadeEventos($this->eventosFaturadosMesAtual);
        // Calcula o total para o mês passado
        $this->totalEventosFaturadosMesPassado = $this->calcularTotalEventos($this->eventosFaturadosMesPassado);
        $this->qtdEventosFaturadosMesPassado = $this->calcularQuantidadeEventos($this->eventosFaturadosMesPassado);
        // Calcula o percentual de mudança
        $this->percentualEventosFaturadosMudanca = $this->calcularPercentualMudanca($this->totalEventosFaturadosMesPassado, $this->totalEventosFaturadosMesAtual);
        $this->percentualQtdEventosFaturadosMudanca = $this->calcularPercentualMudanca($this->qtdEventosFaturadosMesPassado, $this->qtdEventosFaturadosMesAtual);
        
        $this->qtdEventosPendentes = $this->eventosPendentes->count();
        $this->qtdEventosEmExecucao = $this->eventosEmExecucao->count();
        $this->qtdEventosVencer = $this->eventosVencer->count();
        $this->qtdEventosVencidos= $this->eventosVencidos->count();
    
    
    }

    private function buscarEventos($inicio = null, $fim = null, $faturamento = null, $status = null)
    {
        $query = Evento::query()
        ->join('eventotipo', 'eventotipo.ideventotipo', '=', 'evento.ideventotipo')
        ->join('prodserv', 'eventotipo.idprodserv', '=', 'prodserv.idprodserv')
        ->where('evento.status', '!=', 'CANCELADO');

        if ($faturamento === 'aberto') {

            if ($inicio){
                $query->whereRaw("CONCAT(evento.data,' ',evento.hora) BETWEEN ? AND ?", [$inicio->format('Y-m-d H:i:s'), $fim->format('Y-m-d H:i:s')]);
            }else{
                // Para eventos em aberto, ajustamos o intervalo de datas
               
                $query->whereRaw("CONCAT(evento.data,' ',evento.hora) <= ?", [$fim->format('Y-m-d H:i:s')]);
            }
        
            $query->where(function ($query) {
                    $query->whereNull('evento.idnfitem')
                            ->orWhere('evento.idnfitem', '');
            });
        } elseif ($faturamento === 'faturado') {
            //$query->where('evento.status', '=', 'PROGRAMADO'); // Substitua 'PROGRAMADO' pelo valor correto se necessário
            $query->whereNotNull('evento.idnfitem');
            $query->whereRaw("CONCAT(evento.data,' ',evento.hora) BETWEEN ? AND ?", [$inicio->format('Y-m-d H:i:s'), $fim->format('Y-m-d H:i:s')]);
        } 
        elseif ($faturamento === 'vencer') {
            //$query->where('evento.status', '=', 'PROGRAMADO'); // Substitua 'PROGRAMADO' pelo valor correto se necessário
            $query->whereRaw("evento.datafim = CURDATE()");
            $query->where("evento.status","!=",'CONCLUÍDO');
        } 
        elseif ($faturamento === 'vencido') {
            //$query->where('evento.status', '=', 'PROGRAMADO'); // Substitua 'PROGRAMADO' pelo valor correto se necessário
            $query->whereRaw("CONCAT(evento.datafim, ' ', if(evento.horafim = '00:00:00','23:59:59',evento.horafim )) < NOW()");
            $query->where("evento.status","!=",'CONCLUÍDO');
        } 

        if (isset($status) ) {
            $query->where("evento.status","=",$status);
        }
    // Obtém a consulta SQL como uma string
    /*$querySql = $query->toSql();
    
    // Obtém os bindings
    $bindings = $query->getBindings();
    
    // Substitui os placeholders '?' pelos bindings
    $fullSql = preg_replace_callback('/\?/', function ($match) use (&$bindings) {
        $item = array_shift($bindings);
        return is_numeric($item) ? $item : "'" . addslashes($item) . "'";
    }, $querySql);
    
    // Descomente a linha abaixo se quiser visualizar a consulta completa no debug
     dump($fullSql);
*/
        return $query->select('evento.*', 'prodserv.valorvenda as prodserv_valorvenda')
            ->get();
    }
    

    private function calcularTotalEventos($eventos)
    {
        $total = 0;

        foreach ($eventos as $evento) {
            // Combine data e hora de início
            $startDateTime = Carbon::parse($evento->data . ' ' . $evento->hora);

            // Combine data e hora de fim
            $endDateTime = Carbon::parse($evento->datafim . ' ' . $evento->horafim);

            // Calcule a duração
            $duration = $startDateTime->diffInMinutes($endDateTime);

            // Converter minutos para horas em decimal
            $hoursInDecimal = $duration / 60;

            // Calcule o valor total do evento
            $total += $evento->prodserv_valorvenda * $hoursInDecimal;
        }

        return $total;
    }

    private function calcularQuantidadeEventos($eventos)
    {
        $totalQuantidade = 0;

        foreach ($eventos as $evento) {
            $totalQuantidade += $evento->qtd; // Soma a quantidade especificada na coluna `qtd` de cada evento.
        }

        return $totalQuantidade;
    }


    private function somarTotalEventos($eventos)
    {
        $total = 0;

        foreach ($eventos as $evento) {
            // Combine data e hora de início
            $startDateTime = Carbon::parse($evento->data . ' ' . $evento->hora);

            // Combine data e hora de fim
            $endDateTime = Carbon::parse($evento->datafim . ' ' . $evento->horafim);

            // Calcule a duração
            $duration = $startDateTime->diffInMinutes($endDateTime);

            // Converter minutos para horas em decimal
            $hoursInDecimal = $duration / 60;

            // Calcule o valor total do evento
            $total += $evento->prodserv_valorvenda * $hoursInDecimal;
        }

        return $total;
    }

    private function calcularPercentualMudanca($totalEventosMesPassado, $totalEventosMesAtual)
    {
        return $totalEventosMesPassado > 0
            ? (($totalEventosMesAtual - $totalEventosMesPassado) / $totalEventosMesPassado) * 100
            : 0;
    }

    public function render()
    {
        return view('livewire.evento-component', [
            'eventosMesAtual' => $this->eventosMesAtual,
            'eventosMesPassado' => $this->eventosMesPassado,
            'percentualEventosMudanca' => $this->percentualEventosMudanca,
            'totalEventosMesAtual' => $this->totalEventosMesAtual,
            'totalEventosMesPassado' => $this->totalEventosMesPassado,
            'eventosEmAbertoMesAtual' => $this->eventosEmAbertoMesAtual,
            'eventosEmAbertoMesPassado' => $this->eventosEmAbertoMesPassado,
            'eventosFaturadosMesAtual' => $this->eventosFaturadosMesAtual,
            'eventosFaturadosMesPassado' => $this->eventosFaturadosMesPassado,
            'totalEventosEmAbertoMesAtual' => $this->totalEventosEmAbertoMesAtual,
            'totalEventosEmAbertoMesPassado' => $this->totalEventosEmAbertoMesPassado,
            'percentualEventosEmAbertoMudanca' => $this->percentualEventosEmAbertoMudanca,
            'totalEventosFaturadosMesAtual' => $this->totalEventosFaturadosMesAtual,
            'totalEventosFaturadosMesPassado' => $this->totalEventosFaturadosMesPassado,
            'percentualEventosFaturadosMudanca' => $this->percentualEventosFaturadosMudanca,
            'qtdEventosMesAtual' => $this->qtdEventosMesAtual, 
            'qtdEventosMesPassado' => $this->qtdEventosMesPassado,
            'percentualQtdEventosMudanca' => $this->percentualQtdEventosMudanca,
            'qtdEventosEmAbertoMesAtual' => $this->qtdEventosEmAbertoMesAtual,
            'qtdEventosEmAbertoMesPassado' => $this->qtdEventosEmAbertoMesPassado,
            'percentualQtdEventosEmAbertoMudanca' => $this->percentualQtdEventosEmAbertoMudanca,
            'qtdEventosFaturadosMesAtual' => $this->qtdEventosFaturadosMesAtual,
            'qtdEventosFaturadosMesPassado' => $this->qtdEventosFaturadosMesPassado,
            'percentualQtdEventosFaturadosMudanca' => $this->percentualQtdEventosFaturadosMudanca,
            'qtdEventosPendentes' => $this->qtdEventosPendentes,
            'qtdEventosEmExecucao' => $this->qtdEventosEmExecucao
        
        ]);
    }
}
