<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\Nf;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class GraphMediaPedidoDieselComponent extends Component
{
    public $mediasConsumoMesAtual;


    public function mount()
    {
        $inicioMesAtual = '2024-01-01';
        $finalMesAtual = '2024-01-30'; 
 
         // Agora você pode chamar a função e obter as médias ordenadas
        $this->mediasConsumoMesAtual = $this->calcularMediaConsumoPorVeiculo($inicioMesAtual, $finalMesAtual);
        
    
        // Exemplo de como exibir as médias de consumo por veículo
    //    foreach ($mediasConsumoMesAtual as $idVeiculo => $mediaConsumo) {
      //      echo "Veículo $idVeiculo: " . number_format($mediaConsumo, 2, '.', '') . " km/l<br>";
      //  }

    }

    public function render()
    {
        return view('livewire.graph-media-pedido-diesel-component', [
            'mediasConsumoMesAtual' => $this->mediasConsumoMesAtual
        ]);
    }

    function calcularMediaConsumoPorVeiculo($inicio, $fim) {
        // Consulta para obter a média de consumo (km/l) do período especificado
        $resultados = DB::select(DB::raw("
            SELECT 
                n.idnf, 
                ni.qtd, 
                n.km,
                n.idveiculo,
                v.placa as rotulo
            FROM nf n
            JOIN nfitem ni ON n.idnf = ni.idnf
            JOIN veiculo v on v.idveiculo = n.idveiculo
            WHERE ni.idprodserv IN (20, 31)
            AND n.dataentrada BETWEEN ? AND ?
            AND n.saida = 'P'
            AND ni.qtd > 0
            ORDER BY n.idveiculo, n.dataentrada
        "), [$inicio, $fim]);

        // Estruturas para armazenar as informações por veículo
        $informacoesPorVeiculo = [];
        foreach ($resultados as $registro) {
            $idVeiculo = $registro->idveiculo;
            $kmAtual = $registro->km;
            $litros = $registro->qtd;
            $rotulo = $registro->rotulo; // Placa do veículo

            if (!isset($informacoesPorVeiculo[$idVeiculo])) {
                $informacoesPorVeiculo[$idVeiculo] = [
                    'kmAnterior' => $kmAtual,
                    'distanciaTotal' => 0,
                    'litrosTotal' => 0,
                    'rotulo' => $rotulo // Inclui o rótulo aqui
                ];
            } else {
                $distancia = $kmAtual - $informacoesPorVeiculo[$idVeiculo]['kmAnterior'];
                $informacoesPorVeiculo[$idVeiculo]['distanciaTotal'] += max($distancia, 0);
                $informacoesPorVeiculo[$idVeiculo]['kmAnterior'] = $kmAtual;
            }
            $informacoesPorVeiculo[$idVeiculo]['litrosTotal'] += $litros;
        }

        // Preparando dados para ordenação e exibição
        $mediasConsumoPorVeiculo = [];
        foreach ($informacoesPorVeiculo as $idVeiculo => $info) {
            $mediaConsumo = $info['litrosTotal'] > 0 ? $info['distanciaTotal'] / $info['litrosTotal'] : 0;
            if ($mediaConsumo > 0) {
                $mediasConsumoPorVeiculo[] = [
                    'id' => $idVeiculo,
                    'rotulo' => $info['rotulo'],
                    'valor' => $mediaConsumo
                ];
            }
        }

        // Ordena o array pelo campo 'valor' em ordem decrescente
        usort($mediasConsumoPorVeiculo, function ($item1, $item2) {
            return $item2['valor'] <=> $item1['valor'];
        });

        // O array $mediasConsumoPorVeiculo está agora ordenado como desejado e pronto para ser usado

      
    
        // Retorna o vetor ordenado de médias de consumo por veículo
        return $mediasConsumoPorVeiculo;
    }
    
    
}


