<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\Nf;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class GraphMediaPedidoVeiculoComponent extends Component
{
    public $mediasPedidoMesAtual;


    public function mount()
    {
        $inicioMesAtual = '2024-01-01';
        $finalMesAtual = '2024-01-30'; 
 
         // Agora você pode chamar a função e obter as médias ordenadas
        $this->mediasPedidoMesAtual = $this->calcularCustoTotalPorVeiculo($inicioMesAtual, $finalMesAtual);
        
    
        // Exemplo de como exibir as médias de Pedido por veículo
    //    foreach ($mediasPedidoMesAtual as $idVeiculo => $mediaPedido) {
      //      echo "Veículo $idVeiculo: " . number_format($mediaPedido, 2, '.', '') . " km/l<br>";
      //  }

    }

    public function render()
    {
        return view('livewire.graph-media-pedido-veiculo-component', [
            'mediasPedidoMesAtual' => $this->mediasPedidoMesAtual
        ]);
    }

    function calcularCustoTotalPorVeiculo($inicio, $fim) {
        // Consulta para obter os valores dos itens (valoritem) para cada veículo no período especificado
        $resultados = DB::select(DB::raw("
            SELECT 
                n.idnf, 
                ni.valoritem, 
                n.idveiculo,
                v.placa as rotulo
            FROM nf n
            JOIN nfitem ni ON n.idnf = ni.idnf
            JOIN veiculo v on v.idveiculo = n.idveiculo
            WHERE not ni.idprodserv IN (20, 31)
            AND n.dataentrada BETWEEN ? AND ?
            AND n.saida = 'P'
            AND ni.qtd > 0
            AND n.idprodservtipo = 2
            ORDER BY n.idveiculo, n.dataentrada
        "), [$inicio, $fim]);
    
        // Estruturas para armazenar os custos totais por veículo
        $custosPorVeiculo = [];
        foreach ($resultados as $registro) {
            $idVeiculo = $registro->idveiculo;
            $valorItem = $registro->valoritem;
            $rotulo = $registro->rotulo; // Placa do veículo
    
            if (!isset($custosPorVeiculo[$idVeiculo])) {
                $custosPorVeiculo[$idVeiculo] = [
                    'rotulo' => $rotulo,
                    'custoTotal' => 0
                ];
            }
            // Soma o valor do item ao custo total do veículo
            $custosPorVeiculo[$idVeiculo]['custoTotal'] += $valorItem;
        }
    
        // Preparando dados para ordenação e exibição
        $custosTotaisPorVeiculo = [];
        foreach ($custosPorVeiculo as $idVeiculo => $info) {
            $custosTotaisPorVeiculo[] = [
                'id' => $idVeiculo,
                'rotulo' => $info['rotulo'],
                'valor' => $info['custoTotal']
            ];
        }
    
        // Ordena o array pelo campo 'valor' em ordem decrescente
        usort($custosTotaisPorVeiculo, function ($item1, $item2) {
            return $item2['valor'] <=> $item1['valor'];
        });
    
        // Retorna o vetor ordenado de custos totais por veículo
        return $custosTotaisPorVeiculo;
    }
    
    
    
}


